/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import javax.crypto.SecretKey;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;

public class PskSecretResult {
    public static final String ALGORITHM_PSK = "PSK";
    public static final String ALGORITHM_MAC = "MAC";
    private final ConnectionId cid;
    private final PskPublicInformation pskIdentity;
    private final SecretKey secret;
    private final Object customArgument;

    public PskSecretResult(ConnectionId cid, PskPublicInformation pskIdentity, SecretKey secret) {
        this(cid, pskIdentity, secret, null);
    }

    public PskSecretResult(ConnectionId cid, PskPublicInformation pskIdentity, SecretKey secret, Object customArgument) {
        String algorithm;
        if (cid == null) {
            throw new NullPointerException("cid must not be null!");
        }
        if (pskIdentity == null) {
            throw new NullPointerException("PSK identity must not be null!");
        }
        if (secret != null && !ALGORITHM_MAC.equals(algorithm = secret.getAlgorithm()) && !ALGORITHM_PSK.equals(algorithm)) {
            throw new IllegalArgumentException("Secret must be either MAC for master secret, or PSK for secret key, but not " + algorithm + "!");
        }
        this.cid = cid;
        this.pskIdentity = pskIdentity;
        this.secret = secret;
        this.customArgument = customArgument;
    }

    public ConnectionId getConnectionId() {
        return this.cid;
    }

    public PskPublicInformation getPskPublicInformation() {
        return this.pskIdentity;
    }

    public SecretKey getSecret() {
        return this.secret;
    }

    public Object getCustomArgument() {
        return this.customArgument;
    }
}

