/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Signature;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCrypto;

public class ThreadLocalSignature
extends ThreadLocalCrypto<Signature> {
    public ThreadLocalSignature(final String algorithm) {
        super(new ThreadLocalCrypto.Factory<Signature>(){

            @Override
            public Signature getInstance() throws GeneralSecurityException {
                Provider provider;
                String oid = Asn1DerDecoder.getEdDsaStandardAlgorithmName((String)algorithm, null);
                if (oid != null && (provider = Asn1DerDecoder.getEdDsaProvider()) != null) {
                    return Signature.getInstance(oid, provider);
                }
                return Signature.getInstance(algorithm);
            }
        });
    }
}

