/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.x509;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticNewAdvancedCertificateVerifier
implements NewAdvancedCertificateVerifier {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final X509Certificate[] trustedCertificates;
    private final Set<RawPublicKeyIdentity> trustedRPKs;
    private final List<CertificateType> supportedCertificateTypes;

    public StaticNewAdvancedCertificateVerifier(X509Certificate[] trustedCertificates, RawPublicKeyIdentity[] trustedRPKs, List<CertificateType> supportedCertificateTypes) {
        if (trustedCertificates == null && trustedRPKs == null) {
            throw new IllegalArgumentException("no trusts provided!");
        }
        if (supportedCertificateTypes == null) {
            supportedCertificateTypes = new ArrayList<CertificateType>(2);
            if (trustedRPKs != null) {
                supportedCertificateTypes.add(CertificateType.RAW_PUBLIC_KEY);
            }
            if (trustedCertificates != null) {
                supportedCertificateTypes.add(CertificateType.X_509);
            }
        } else {
            if (supportedCertificateTypes.isEmpty()) {
                throw new IllegalArgumentException("list of supported certificate types must not be empty!");
            }
            if (supportedCertificateTypes.contains((Object)CertificateType.RAW_PUBLIC_KEY) && trustedRPKs == null) {
                throw new IllegalArgumentException("RPK support requires RPK trusts!");
            }
            if (supportedCertificateTypes.contains((Object)CertificateType.X_509) && trustedCertificates == null) {
                throw new IllegalArgumentException("x509support requires x509 trusts!");
            }
        }
        this.trustedCertificates = trustedCertificates == null ? null : Arrays.copyOf(trustedCertificates, trustedCertificates.length);
        this.trustedRPKs = trustedRPKs == null ? null : new HashSet<RawPublicKeyIdentity>(Arrays.asList(trustedRPKs));
        this.supportedCertificateTypes = Collections.unmodifiableList(supportedCertificateTypes);
    }

    @Override
    public List<CertificateType> getSupportedCertificateType() {
        return this.supportedCertificateTypes;
    }

    @Override
    public CertificateVerificationResult verifyCertificate(ConnectionId cid, ServerNames serverName, Boolean clientUsage, boolean truncateCertificatePath, CertificateMessage message, DTLSSession session) {
        try {
            CertPath certChain = message.getCertificateChain();
            if (certChain == null) {
                RawPublicKeyIdentity rpk;
                if (this.trustedRPKs == null) {
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, session.getPeer());
                    throw new HandshakeException("RPK verification not enabled!", alert);
                }
                PublicKey publicKey = message.getPublicKey();
                if (!this.trustedRPKs.isEmpty() && !this.trustedRPKs.contains(rpk = new RawPublicKeyIdentity(publicKey))) {
                    this.LOGGER.debug("Certificate validation failed: Raw public key is not trusted");
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
                    throw new HandshakeException("Raw public key is not trusted!", alert);
                }
                return new CertificateVerificationResult(cid, publicKey, null);
            }
            if (this.trustedCertificates == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, session.getPeer());
                throw new HandshakeException("x509 verification not enabled!", alert);
            }
            try {
                Certificate certificate;
                CertPath certPath = message.getCertificateChain();
                if (clientUsage != null && !message.isEmpty() && (certificate = certPath.getCertificates().get(0)) instanceof X509Certificate && !CertPathUtil.canBeUsedForAuthentication((X509Certificate)((X509Certificate)certificate), (boolean)clientUsage)) {
                    this.LOGGER.debug("Certificate validation failed: key usage doesn't match");
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
                    throw new HandshakeException("Key Usage doesn't match!", alert);
                }
                certChain = CertPathUtil.validateCertificatePathWithIssuer((boolean)truncateCertificatePath, (CertPath)certPath, (X509Certificate[])this.trustedCertificates);
                return new CertificateVerificationResult(cid, certChain, null);
            }
            catch (GeneralSecurityException e) {
                if (this.LOGGER.isTraceEnabled()) {
                    this.LOGGER.trace("Certificate validation failed", (Throwable)e);
                } else if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Certificate validation failed due to {}", (Object)e.getMessage());
                }
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
                throw new HandshakeException("Certificate chain could not be validated", alert, e);
            }
        }
        catch (HandshakeException e) {
            this.LOGGER.debug("Certificate validation failed!", (Throwable)e);
            return new CertificateVerificationResult(cid, e, null);
        }
    }

    @Override
    public List<X500Principal> getAcceptedIssuers() {
        if (this.trustedCertificates != null) {
            return CertPathUtil.toSubjects(Arrays.asList(this.trustedCertificates));
        }
        return CertPathUtil.toSubjects(null);
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected X509Certificate[] trustedCertificates;
        protected RawPublicKeyIdentity[] trustedRPKs;
        protected List<CertificateType> supportedCertificateTypes;

        public Builder setTrustedCertificates(Certificate ... trustedCertificates) {
            if (trustedCertificates == null) {
                this.trustedCertificates = null;
            } else if (trustedCertificates.length == 0) {
                this.trustedCertificates = new X509Certificate[0];
            } else {
                X509Certificate[] certificates = SslContextUtil.asX509Certificates((Certificate[])trustedCertificates);
                SslContextUtil.ensureUniqueCertificates((X509Certificate[])certificates);
                this.trustedCertificates = certificates;
            }
            return this;
        }

        public Builder setTrustAllCertificates() {
            this.trustedCertificates = new X509Certificate[0];
            return this;
        }

        public Builder setTrustedRPKs(RawPublicKeyIdentity ... trustedRPKs) {
            this.trustedRPKs = trustedRPKs;
            return this;
        }

        public Builder setTrustAllRPKs() {
            this.trustedRPKs = new RawPublicKeyIdentity[0];
            return this;
        }

        public Builder setSupportedCertificateTypes(List<CertificateType> supportedCertificateTypes) {
            this.supportedCertificateTypes = supportedCertificateTypes;
            return this;
        }

        public boolean hasTrusts() {
            return this.trustedCertificates != null || this.trustedRPKs != null;
        }

        public NewAdvancedCertificateVerifier build() {
            return new StaticNewAdvancedCertificateVerifier(this.trustedCertificates, this.trustedRPKs, this.supportedCertificateTypes);
        }
    }
}

