/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.elements.exception.EndpointMismatchException;
import org.eclipse.californium.elements.exception.EndpointUnconnectedException;
import org.eclipse.californium.elements.exception.MulticastNotSupportedException;
import org.eclipse.californium.elements.tcp.netty.CloseOnErrorHandler;
import org.eclipse.californium.elements.tcp.netty.CloseOnIdleHandler;
import org.eclipse.californium.elements.tcp.netty.DatagramFramer;
import org.eclipse.californium.elements.tcp.netty.DispatchHandler;
import org.eclipse.californium.elements.tcp.netty.TcpContextUtil;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServerConnector
implements Connector {
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();
    private static final ThreadGroup TCP_THREAD_GROUP = new ThreadGroup("Californium/TCP-Server");
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final int numberOfThreads;
    private final int connectionIdleTimeoutSeconds;
    private final InetSocketAddress localAddress;
    private final TcpContextUtil contextUtil;
    private final ConcurrentMap<SocketAddress, Channel> activeChannels = new ConcurrentHashMap<SocketAddress, Channel>();
    private volatile EndpointContextMatcher endpointContextMatcher;
    private volatile InetSocketAddress effectiveLocalAddress;
    private RawDataChannel rawDataChannel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public TcpServerConnector(InetSocketAddress localAddress, int numberOfThreads, int idleTimeout) {
        this(localAddress, numberOfThreads, idleTimeout, new TcpContextUtil());
    }

    protected TcpServerConnector(InetSocketAddress localAddress, int numberOfThreads, int idleTimeout, TcpContextUtil contextUtil) {
        this.numberOfThreads = numberOfThreads;
        this.connectionIdleTimeoutSeconds = idleTimeout;
        this.localAddress = localAddress;
        this.contextUtil = contextUtil;
        this.effectiveLocalAddress = localAddress;
    }

    public synchronized void start() throws IOException {
        if (this.rawDataChannel == null) {
            throw new IllegalStateException("Cannot start without message handler.");
        }
        if (this.bossGroup != null) {
            throw new IllegalStateException("Connector already started");
        }
        if (this.workerGroup != null) {
            throw new IllegalStateException("Connector already started");
        }
        int id = THREAD_COUNTER.incrementAndGet();
        this.bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory("TCP-Server-" + id, TCP_THREAD_GROUP));
        this.workerGroup = new NioEventLoopGroup(this.numberOfThreads, (ThreadFactory)new DaemonThreadFactory("TCP-Server-" + id + "#", TCP_THREAD_GROUP));
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelRegistry()).option(ChannelOption.SO_BACKLOG, (Object)100)).option(ChannelOption.AUTO_READ, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ChannelFuture channelFuture = bootstrap.bind((SocketAddress)this.localAddress).syncUninterruptibly();
        if (channelFuture.isSuccess() && 0 == this.localAddress.getPort()) {
            InetSocketAddress listenAddress = (InetSocketAddress)channelFuture.channel().localAddress();
            this.effectiveLocalAddress = new InetSocketAddress(this.localAddress.getAddress(), listenAddress.getPort());
        }
    }

    public synchronized void stop() {
        if (null != this.bossGroup) {
            this.bossGroup.shutdownGracefully(0L, 500L, TimeUnit.MILLISECONDS).syncUninterruptibly();
            this.bossGroup = null;
        }
        if (null != this.workerGroup) {
            this.workerGroup.shutdownGracefully(0L, 500L, TimeUnit.MILLISECONDS).syncUninterruptibly();
            this.workerGroup = null;
        }
        this.effectiveLocalAddress = this.localAddress;
    }

    public void destroy() {
        this.stop();
    }

    public void send(final RawData msg) {
        if (msg == null) {
            throw new NullPointerException("Message must not be null");
        }
        if (msg.isMulticast()) {
            this.LOGGER.warn("TcpConnector drops {} bytes to multicast {}:{}", new Object[]{msg.getSize(), msg.getAddress(), msg.getPort()});
            msg.onError((Throwable)new MulticastNotSupportedException("TCP doesn't support multicast!"));
            return;
        }
        if (this.bossGroup == null) {
            msg.onError((Throwable)new IllegalStateException("TCP server connector not running!"));
            return;
        }
        Channel channel = (Channel)this.activeChannels.get(msg.getInetSocketAddress());
        if (channel == null) {
            this.LOGGER.debug("Attempting to send message to an address without an active connection {}", (Object)msg.getAddress());
            msg.onError((Throwable)new EndpointUnconnectedException());
            return;
        }
        EndpointContext context = this.contextUtil.buildEndpointContext(channel);
        EndpointContextMatcher endpointMatcher = this.getEndpointContextMatcher();
        if (null != endpointMatcher && !endpointMatcher.isToBeSent(msg.getEndpointContext(), context)) {
            this.LOGGER.warn("TcpConnector drops {} bytes to {}:{}", new Object[]{msg.getSize(), msg.getAddress(), msg.getPort()});
            msg.onError((Throwable)new EndpointMismatchException());
            return;
        }
        msg.onContextEstablished(context);
        ChannelFuture channelFuture = channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])msg.getBytes()));
        channelFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    msg.onSent();
                } else if (future.isCancelled()) {
                    msg.onError((Throwable)new CancellationException());
                } else {
                    msg.onError(future.cause());
                }
            }
        });
    }

    public void setRawDataReceiver(RawDataChannel messageHandler) {
        if (this.rawDataChannel != null) {
            throw new IllegalStateException("RawDataChannel already set");
        }
        this.rawDataChannel = messageHandler;
    }

    public void setEndpointContextMatcher(EndpointContextMatcher matcher) {
        this.endpointContextMatcher = matcher;
    }

    private EndpointContextMatcher getEndpointContextMatcher() {
        return this.endpointContextMatcher;
    }

    public InetSocketAddress getAddress() {
        return this.effectiveLocalAddress;
    }

    protected void onNewChannelCreated(Channel ch) {
    }

    public String getProtocol() {
        return "TCP";
    }

    public String toString() {
        return this.getProtocol() + "-" + StringUtil.toString((InetSocketAddress)this.getAddress());
    }

    static {
        TCP_THREAD_GROUP.setDaemon(false);
    }

    private class ChannelTracker
    extends ChannelInboundHandlerAdapter {
        private ChannelTracker() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            TcpServerConnector.this.activeChannels.put(ctx.channel().remoteAddress(), ctx.channel());
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            TcpServerConnector.this.activeChannels.remove(ctx.channel().remoteAddress());
        }
    }

    private class ChannelRegistry
    extends ChannelInitializer<SocketChannel> {
        private ChannelRegistry() {
        }

        protected void initChannel(SocketChannel ch) throws Exception {
            TcpServerConnector.this.onNewChannelCreated((Channel)ch);
            ch.pipeline().addLast(new ChannelHandler[]{new ChannelTracker()});
            ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, TcpServerConnector.this.connectionIdleTimeoutSeconds)});
            ch.pipeline().addLast(new ChannelHandler[]{new CloseOnIdleHandler()});
            ch.pipeline().addLast(new ChannelHandler[]{new DatagramFramer(TcpServerConnector.this.contextUtil)});
            ch.pipeline().addLast(new ChannelHandler[]{new DispatchHandler(TcpServerConnector.this.rawDataChannel)});
            ch.pipeline().addLast(new ChannelHandler[]{new CloseOnErrorHandler()});
        }
    }
}

