/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.LogProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.support.processor.DefaultMaskingFormatter;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReifier
extends ProcessorReifier<LogDefinition> {
    public LogReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (LogDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        StringHelper.notEmpty((String)((LogDefinition)this.definition).getMessage(), (String)"message", (Object)this);
        String msg = this.parseString(((LogDefinition)this.definition).getMessage());
        Expression exp = this.camelContext.resolveLanguage("simple").createExpression(msg);
        Logger logger = ((LogDefinition)this.definition).getLogger();
        if (logger == null && ObjectHelper.isNotEmpty((Object)((LogDefinition)this.definition).getLoggerRef())) {
            logger = this.mandatoryLookup(((LogDefinition)this.definition).getLoggerRef(), Logger.class);
        }
        if (logger == null) {
            Map<String, Logger> availableLoggers = this.findByTypeWithName(Logger.class);
            if (availableLoggers.size() == 1) {
                logger = availableLoggers.values().iterator().next();
                this.log.debug("Using custom Logger: {}", (Object)logger);
            } else if (availableLoggers.size() > 1) {
                this.log.debug("More than one {} instance found in the registry. Falling back to create logger by name.", (Object)Logger.class.getName());
            }
        }
        if (logger == null) {
            String name = this.parseString(((LogDefinition)this.definition).getLogName());
            if (name == null && (name = this.camelContext.getGlobalOption("CamelLogEipName")) != null) {
                this.log.debug("Using logName from CamelContext properties: {}", (Object)name);
            }
            if (name == null) {
                name = this.route.getRouteId();
                this.log.debug("LogName is not configured, using route id as logName: {}", (Object)name);
            }
            logger = LoggerFactory.getLogger((String)name);
        }
        LoggingLevel level = ((LogDefinition)this.definition).getLoggingLevel() != null ? this.parse(LoggingLevel.class, ((LogDefinition)this.definition).getLoggingLevel()) : LoggingLevel.INFO;
        CamelLogger camelLogger = new CamelLogger(logger, level, ((LogDefinition)this.definition).getMarker());
        return new LogProcessor(exp, camelLogger, this.getMaskingFormatter(), ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getLogListeners());
    }

    private MaskingFormatter getMaskingFormatter() {
        if (this.route.isLogMask().booleanValue()) {
            MaskingFormatter formatter = this.lookup("CamelCustomLogMask", MaskingFormatter.class);
            if (formatter == null) {
                formatter = new DefaultMaskingFormatter();
            }
            return formatter;
        }
        return null;
    }
}

