/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cassandra.CassandraEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.utils.cassandra.CassandraUtils;

public class CassandraProducer
extends DefaultProducer {
    private PreparedStatement preparedStatement;

    public CassandraProducer(CassandraEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.isPrepareStatements() && this.getEndpoint().getCql() != null) {
            this.preparedStatement = this.getEndpoint().prepareStatement();
        }
    }

    protected void doStop() throws Exception {
        this.preparedStatement = null;
        super.doStop();
    }

    public CassandraEndpoint getEndpoint() {
        return (CassandraEndpoint)super.getEndpoint();
    }

    public boolean isPrepareStatements() {
        return this.getEndpoint().isPrepareStatements();
    }

    private Object[] getCqlParams(Message message) {
        Object[] cqlParams;
        Object cqlParamsObj = message.getBody();
        Class<Object[]> objectArrayClazz = Object[].class;
        if (cqlParamsObj == null) {
            cqlParams = null;
        } else if (objectArrayClazz.isInstance(cqlParamsObj)) {
            cqlParams = (Object[])objectArrayClazz.cast(cqlParamsObj);
        } else if (cqlParamsObj instanceof Collection) {
            Collection cqlParamsColl = (Collection)cqlParamsObj;
            cqlParams = cqlParamsColl.toArray();
        } else {
            cqlParams = new Object[]{cqlParamsObj};
        }
        return cqlParams;
    }

    private ResultSet execute(Message message) {
        Object messageCql = message.getHeader("CamelCqlQuery");
        if (messageCql instanceof String && ((String)messageCql).isEmpty()) {
            messageCql = null;
        }
        Object[] cqlParams = this.getCqlParams(message);
        Session session = this.getEndpoint().getSessionHolder().getSession();
        ResultSet resultSet = this.isPrepareStatements() ? this.executePreparedStatement(session, messageCql, cqlParams) : this.executeStatement(session, messageCql, cqlParams);
        return resultSet;
    }

    private ResultSet executePreparedStatement(Session session, Object messageCql, Object[] cqlParams) {
        PreparedStatement lPreparedStatement;
        if (messageCql == null) {
            lPreparedStatement = this.preparedStatement;
        } else if (messageCql instanceof String) {
            lPreparedStatement = this.getEndpoint().prepareStatement((String)messageCql);
        } else if (messageCql instanceof RegularStatement) {
            lPreparedStatement = this.getEndpoint().getSession().prepare((RegularStatement)messageCql);
        } else {
            throw new IllegalArgumentException("Invalid CamelCqlQuery header");
        }
        ResultSet resultSet = CassandraUtils.isEmpty(cqlParams) ? session.execute((Statement)lPreparedStatement.bind()) : session.execute((Statement)lPreparedStatement.bind(cqlParams));
        return resultSet;
    }

    private ResultSet executeStatement(Session session, Object messageCql, Object[] cqlParams) {
        String cql = null;
        RegularStatement statement = null;
        if (messageCql == null) {
            cql = this.getEndpoint().getCql();
        } else if (messageCql instanceof String) {
            cql = (String)messageCql;
        } else if (messageCql instanceof RegularStatement) {
            statement = (RegularStatement)messageCql;
        } else {
            throw new IllegalArgumentException("Invalid CamelCqlQuery header");
        }
        ResultSet resultSet = statement != null ? session.execute((Statement)statement) : (CassandraUtils.isEmpty(cqlParams) ? session.execute(cql) : session.execute(cql, cqlParams));
        return resultSet;
    }

    public void process(Exchange exchange) throws Exception {
        exchange.getMessage().copyFrom(exchange.getIn());
        ResultSet resultSet = this.execute(exchange.getIn());
        this.getEndpoint().fillMessage(resultSet, exchange.getMessage());
    }
}

