/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public interface GraphWriter {
    public void writeGraph(OutputStream var1, Graph var2) throws IOException;

    public void writeVertex(OutputStream var1, Vertex var2, Direction var3) throws IOException;

    public void writeVertex(OutputStream var1, Vertex var2) throws IOException;

    default public void writeVertices(OutputStream outputStream, Iterator<Vertex> vertexIterator, Direction direction) throws IOException {
        while (vertexIterator.hasNext()) {
            this.writeVertex(outputStream, vertexIterator.next(), direction);
        }
    }

    default public void writeVertices(OutputStream outputStream, Iterator<Vertex> vertexIterator) throws IOException {
        while (vertexIterator.hasNext()) {
            this.writeVertex(outputStream, vertexIterator.next());
        }
    }

    public void writeEdge(OutputStream var1, Edge var2) throws IOException;

    public void writeVertexProperty(OutputStream var1, VertexProperty var2) throws IOException;

    public void writeProperty(OutputStream var1, Property var2) throws IOException;

    public void writeObject(OutputStream var1, Object var2) throws IOException;

    public static interface WriterBuilder<T extends GraphWriter> {
        public T create();
    }
}

