/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategy;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategyFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.internal.core.util.NanoTime;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSetMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.SetMultimap;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
class KeyspaceTokenMap {
    private static final Logger LOG = LoggerFactory.getLogger(KeyspaceTokenMap.class);
    private final List<Token> ring;
    private final SetMultimap<Node, TokenRange> tokenRangesByNode;
    private final SetMultimap<Token, Node> replicasByToken;
    private final TokenFactory tokenFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyspaceTokenMap build(Map<String, String> replicationConfig, Map<Token, Node> tokenToPrimary, List<Token> ring, Set<TokenRange> tokenRanges, TokenFactory tokenFactory, ReplicationStrategyFactory replicationStrategyFactory, String logPrefix) {
        KeyspaceTokenMap keyspaceTokenMap;
        long start = System.nanoTime();
        try {
            ImmutableSetMultimap tokenRangesByNode;
            ReplicationStrategy strategy = replicationStrategyFactory.newInstance(replicationConfig);
            SetMultimap<Token, Node> replicasByToken = strategy.computeReplicasByToken(tokenToPrimary, ring);
            if (ring.size() == 1) {
                ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
                for (Node node : tokenToPrimary.values()) {
                    builder.putAll((Object)node, tokenRanges);
                }
                tokenRangesByNode = builder.build();
            } else {
                tokenRangesByNode = KeyspaceTokenMap.buildTokenRangesByNode(tokenRanges, replicasByToken);
            }
            keyspaceTokenMap = new KeyspaceTokenMap(ring, (SetMultimap<Node, TokenRange>)tokenRangesByNode, replicasByToken, tokenFactory);
        }
        catch (Throwable throwable) {
            LOG.debug("[{}] Computing keyspace-level data for {} took {}", new Object[]{logPrefix, replicationConfig, NanoTime.formatTimeSince(start)});
            throw throwable;
        }
        LOG.debug("[{}] Computing keyspace-level data for {} took {}", new Object[]{logPrefix, replicationConfig, NanoTime.formatTimeSince(start)});
        return keyspaceTokenMap;
    }

    private KeyspaceTokenMap(List<Token> ring, SetMultimap<Node, TokenRange> tokenRangesByNode, SetMultimap<Token, Node> replicasByToken, TokenFactory tokenFactory) {
        this.ring = ring;
        this.tokenRangesByNode = tokenRangesByNode;
        this.replicasByToken = replicasByToken;
        this.tokenFactory = tokenFactory;
    }

    Set<TokenRange> getTokenRanges(Node replica) {
        return this.tokenRangesByNode.get((Object)replica);
    }

    Set<Node> getReplicas(ByteBuffer partitionKey) {
        return this.getReplicas(this.tokenFactory.hash(partitionKey));
    }

    Set<Node> getReplicas(Token token) {
        Set nodes = this.replicasByToken.get((Object)token);
        if (!nodes.isEmpty()) {
            return nodes;
        }
        int i = Collections.binarySearch(this.ring, token);
        if (i < 0 && (i = -i - 1) >= this.ring.size()) {
            i = 0;
        }
        return this.replicasByToken.get((Object)this.ring.get(i));
    }

    private static SetMultimap<Node, TokenRange> buildTokenRangesByNode(Set<TokenRange> tokenRanges, SetMultimap<Token, Node> replicasByToken) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (TokenRange range : tokenRanges) {
            for (Node node : replicasByToken.get((Object)range.getEnd())) {
                result.put((Object)node, (Object)range);
            }
        }
        return result.build();
    }
}

