/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.DropwizardMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DropwizardNodeMetricUpdater
extends DropwizardMetricUpdater<NodeMetric>
implements NodeMetricUpdater {
    private final String metricNamePrefix;
    private final Runnable signalMetricUpdated;

    public DropwizardNodeMetricUpdater(Node node, Set<NodeMetric> enabledMetrics, MetricRegistry registry, InternalDriverContext context, Runnable signalMetricUpdated) {
        super(enabledMetrics, registry);
        this.signalMetricUpdated = signalMetricUpdated;
        this.metricNamePrefix = this.buildPrefix(context.getSessionName(), node.getEndPoint());
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        if (enabledMetrics.contains(DefaultNodeMetric.OPEN_CONNECTIONS)) {
            this.registry.register(this.buildFullName(DefaultNodeMetric.OPEN_CONNECTIONS, (String)null), (Metric)((Gauge)node::getOpenConnections));
        }
        this.initializePoolGauge(DefaultNodeMetric.AVAILABLE_STREAMS, node, ChannelPool::getAvailableIds, context);
        this.initializePoolGauge(DefaultNodeMetric.IN_FLIGHT, node, ChannelPool::getInFlight, context);
        this.initializePoolGauge(DefaultNodeMetric.ORPHANED_STREAMS, node, ChannelPool::getOrphanedIds, context);
        this.initializeHdrTimer(DefaultNodeMetric.CQL_MESSAGES, config, DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_HIGHEST, DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_DIGITS, DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_INTERVAL);
        this.initializeDefaultCounter(DefaultNodeMetric.UNSENT_REQUESTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.ABORTED_REQUESTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.WRITE_TIMEOUTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.READ_TIMEOUTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.UNAVAILABLES, null);
        this.initializeDefaultCounter(DefaultNodeMetric.OTHER_ERRORS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_ABORTED, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_READ_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_WRITE_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_UNAVAILABLE, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_OTHER_ERROR, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_ABORTED, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_READ_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_WRITE_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_UNAVAILABLE, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_OTHER_ERROR, null);
        this.initializeDefaultCounter(DefaultNodeMetric.SPECULATIVE_EXECUTIONS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.CONNECTION_INIT_ERRORS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.AUTHENTICATION_ERRORS, null);
        this.initializeHdrTimer(DseNodeMetric.GRAPH_MESSAGES, context.getConfig().getDefaultProfile(), DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_HIGHEST, DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_DIGITS, DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_INTERVAL);
    }

    @Override
    public String buildFullName(NodeMetric metric, String profileName) {
        return this.metricNamePrefix + metric.getPath();
    }

    private String buildPrefix(String sessionName, EndPoint endPoint) {
        return sessionName + ".nodes." + endPoint.asMetricPrefix() + ".";
    }

    @Override
    public void incrementCounter(NodeMetric metric, String profileName, long amount) {
        this.signalMetricUpdated.run();
        super.incrementCounter(metric, profileName, amount);
    }

    @Override
    public void updateHistogram(NodeMetric metric, String profileName, long value) {
        this.signalMetricUpdated.run();
        super.updateHistogram(metric, profileName, value);
    }

    @Override
    public void markMeter(NodeMetric metric, String profileName, long amount) {
        this.signalMetricUpdated.run();
        super.markMeter(metric, profileName, amount);
    }

    @Override
    public void updateTimer(NodeMetric metric, String profileName, long duration, TimeUnit unit) {
        this.signalMetricUpdated.run();
        super.updateTimer(metric, profileName, duration, unit);
    }

    @Override
    public <T extends Metric> T getMetric(NodeMetric metric, String profileName) {
        this.signalMetricUpdated.run();
        return super.getMetric(metric, profileName);
    }

    private void initializePoolGauge(NodeMetric metric, Node node, Function<ChannelPool, Integer> reading, InternalDriverContext context) {
        if (this.enabledMetrics.contains(metric)) {
            this.registry.register(this.buildFullName(metric, (String)null), (Metric)((Gauge)() -> {
                ChannelPool pool = context.getPoolManager().getPools().get(node);
                return pool == null ? 0 : (Integer)reading.apply(pool);
            }));
        }
    }

    public void cleanupNodeMetrics() {
        this.registry.removeMatching((name, metric) -> name.startsWith(this.metricNamePrefix));
    }
}

