/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cassandra;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class CassandraEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":beanRef:hosts:port/keyspace";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "cql".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "beanRef", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "hosts", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "port", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "keyspace", null, false, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(36);
        props.add("basicPropertyBinding");
        props.add("backoffMultiplier");
        props.add("beanRef");
        props.add("session");
        props.add("synchronous");
        props.add("initialDelay");
        props.add("scheduler");
        props.add("prepareStatements");
        props.add("password");
        props.add("bridgeErrorHandler");
        props.add("useFixedDelay");
        props.add("runLoggingLevel");
        props.add("backoffErrorThreshold");
        props.add("clusterName");
        props.add("greedy");
        props.add("scheduledExecutorService");
        props.add("repeatCount");
        props.add("timeUnit");
        props.add("resultSetConversionStrategy");
        props.add("hosts");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("loadBalancingPolicyClass");
        props.add("exchangePattern");
        props.add("datacenter");
        props.add("backoffIdleThreshold");
        props.add("keyspace");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("pollStrategy");
        props.add("port");
        props.add("startScheduler");
        props.add("consistencyLevel");
        props.add("exceptionHandler");
        props.add("cql");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

