/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.internal.querybuilder.select.CollectionSelector;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public class FunctionSelector
extends CollectionSelector {
    private final CqlIdentifier keyspaceId;
    private final CqlIdentifier functionId;

    public FunctionSelector(@Nullable CqlIdentifier keyspaceId, @NonNull CqlIdentifier functionId, @NonNull Iterable<Selector> arguments) {
        this(keyspaceId, functionId, arguments, null);
    }

    public FunctionSelector(@Nullable CqlIdentifier keyspaceId, @NonNull CqlIdentifier functionId, @NonNull Iterable<Selector> elementSelectors, @Nullable CqlIdentifier alias) {
        super(elementSelectors, FunctionSelector.buildOpening(keyspaceId, functionId), ")", alias);
        this.keyspaceId = keyspaceId;
        this.functionId = functionId;
    }

    @Override
    @NonNull
    public Selector as(@NonNull CqlIdentifier alias) {
        return new FunctionSelector(this.keyspaceId, this.functionId, this.getElementSelectors(), alias);
    }

    @Nullable
    public CqlIdentifier getKeyspaceId() {
        return this.keyspaceId;
    }

    @NonNull
    public CqlIdentifier getFunctionId() {
        return this.functionId;
    }

    @Override
    @NonNull
    public Iterable<Selector> getElementSelectors() {
        return super.getElementSelectors();
    }

    private static String buildOpening(CqlIdentifier keyspaceId, CqlIdentifier functionId) {
        return keyspaceId == null ? functionId.asCql(true) + "(" : keyspaceId.asCql(true) + "." + functionId.asCql(true) + "(";
    }
}

