/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentBuffer;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.io.Serializable;

public final class Line
extends Segment
implements Serializable {
    private static final long serialVersionUID = 2L;

    @Override
    public Geometry.Type getType() {
        return Geometry.Type.Line;
    }

    @Override
    public double calculateLength2D() {
        double dx = this.m_xStart - this.m_xEnd;
        double dy = this.m_yStart - this.m_yEnd;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    boolean isDegenerate(double tolerance) {
        double dx = this.m_xStart - this.m_xEnd;
        double dy = this.m_yStart - this.m_yEnd;
        return Math.sqrt(dx * dx + dy * dy) <= tolerance;
    }

    @Override
    public boolean isCurve() {
        return false;
    }

    @Override
    Point2D _getTangent(double t) {
        Point2D pt = new Point2D();
        pt.sub(this.getEndXY(), this.getStartXY());
        return pt;
    }

    @Override
    boolean _isDegenerate(double tolerance) {
        return this.calculateLength2D() <= tolerance;
    }

    public Line() {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
    }

    Line(VertexDescription vd) {
        this.m_description = vd;
    }

    Line(double x1, double y1, double x2, double y2) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.setStartXY(x1, y1);
        this.setEndXY(x2, y2);
    }

    @Override
    public void queryEnvelope(Envelope env) {
        env.setEmpty();
        env.assignVertexDescription(this.m_description);
        Envelope2D env2D = new Envelope2D();
        this.queryEnvelope2D(env2D);
        env.setEnvelope2D(env2D);
        int n = this.m_description.getAttributeCount();
        for (int i = 1; i < n; ++i) {
            int semantics = this.m_description.getSemantics(i);
            int iord = 0;
            int nord = VertexDescription.getComponentCount(semantics);
            while (i < nord) {
                Envelope1D interval = this.queryInterval(semantics, iord);
                env.setInterval(semantics, iord, interval);
                ++i;
            }
        }
    }

    @Override
    public void queryEnvelope2D(Envelope2D env) {
        env.setCoords(this.m_xStart, this.m_yStart, this.m_xEnd, this.m_yEnd);
        env.normalize();
    }

    @Override
    void queryEnvelope3D(Envelope3D env) {
        env.setEmpty();
        env.merge(this.m_xStart, this.m_yStart, this._getAttributeAsDbl(0, 1, 0));
        env.merge(this.m_xEnd, this.m_yEnd, this._getAttributeAsDbl(1, 1, 0));
    }

    @Override
    public void applyTransformation(Transformation2D transform) {
        this._touch();
        Point2D pt = new Point2D();
        pt.x = this.m_xStart;
        pt.y = this.m_yStart;
        transform.transform(pt, pt);
        this.m_xStart = pt.x;
        this.m_yStart = pt.y;
        pt.x = this.m_xEnd;
        pt.y = this.m_yEnd;
        transform.transform(pt, pt);
        this.m_xEnd = pt.x;
        this.m_yEnd = pt.y;
    }

    @Override
    void applyTransformation(Transformation3D transform) {
        this._touch();
        Point3D pt = new Point3D();
        pt.x = this.m_xStart;
        pt.y = this.m_yStart;
        pt.z = this._getAttributeAsDbl(0, 1, 0);
        pt = transform.transform(pt);
        this.m_xStart = pt.x;
        this.m_yStart = pt.y;
        this._setAttribute(0, 1, 0, pt.z);
        pt.x = this.m_xEnd;
        pt.y = this.m_yEnd;
        pt.z = this._getAttributeAsDbl(1, 1, 0);
        pt = transform.transform(pt);
        this.m_xEnd = pt.x;
        this.m_yEnd = pt.y;
        this._setAttribute(1, 1, 0, pt.z);
    }

    @Override
    public Geometry createInstance() {
        return new Line(this.m_description);
    }

    @Override
    double _calculateArea2DHelper(double xorg, double yorg) {
        return (this.m_xEnd - xorg - (this.m_xStart - xorg)) * (this.m_yEnd - yorg + (this.m_yStart - yorg)) * 0.5;
    }

    @Override
    double tToLength(double t) {
        return t * this.calculateLength2D();
    }

    @Override
    double lengthToT(double len) {
        return len / this.calculateLength2D();
    }

    double getCoordX_(double t) {
        return MathUtils.lerp(this.m_xStart, this.m_xEnd, t);
    }

    double getCoordY_(double t) {
        return MathUtils.lerp(this.m_yStart, this.m_yEnd, t);
    }

    @Override
    void getCoord2D(double t, Point2D pt) {
        MathUtils.lerp(this.m_xStart, this.m_yStart, this.m_xEnd, this.m_yEnd, t, pt);
    }

    @Override
    Segment cut(double t1, double t2) {
        SegmentBuffer segmentBuffer = new SegmentBuffer();
        this.cut(t1, t2, segmentBuffer);
        return segmentBuffer.get();
    }

    @Override
    void cut(double t1, double t2, SegmentBuffer subSegmentBuffer) {
        if (subSegmentBuffer == null) {
            throw new IllegalArgumentException();
        }
        subSegmentBuffer.createLine();
        Segment subSegment = subSegmentBuffer.get();
        subSegment.assignVertexDescription(this.m_description);
        Point2D point = new Point2D();
        this.getCoord2D(t1, point);
        subSegment.setStartXY(point.x, point.y);
        this.getCoord2D(t2, point);
        subSegment.setEndXY(point.x, point.y);
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 1; iattr < nattr; ++iattr) {
            int semantics = this.m_description._getSemanticsImpl(iattr);
            int ncomps = VertexDescription.getComponentCount(semantics);
            for (int ordinate = 0; ordinate < ncomps; ++ordinate) {
                double value1 = this.getAttributeAsDbl(t1, semantics, ordinate);
                subSegment.setStartAttribute(semantics, ordinate, value1);
                double value2 = this.getAttributeAsDbl(t2, semantics, ordinate);
                subSegment.setEndAttribute(semantics, ordinate, value2);
            }
        }
    }

    @Override
    public double getAttributeAsDbl(double t, int semantics, int ordinate) {
        if (semantics == 0) {
            return ordinate == 0 ? this.getCoord2D((double)t).x : this.getCoord2D((double)t).y;
        }
        int interpolation = VertexDescription.getInterpolation(semantics);
        switch (interpolation) {
            case 0: {
                if (t < 0.5) {
                    return this.getStartAttributeAsDbl(semantics, ordinate);
                }
                return this.getEndAttributeAsDbl(semantics, ordinate);
            }
            case 1: {
                double s = this.getStartAttributeAsDbl(semantics, ordinate);
                double e = this.getEndAttributeAsDbl(semantics, ordinate);
                return MathUtils.lerp(s, e, t);
            }
            case 2: {
                throw new GeometryException("not implemented");
            }
        }
        throw GeometryException.GeometryInternalError();
    }

    @Override
    double getClosestCoordinate(Point2D inputPt, boolean bExtrapolate) {
        double vx = this.m_xEnd - this.m_xStart;
        double vy = this.m_yEnd - this.m_yStart;
        double v2 = vx * vx + vy * vy;
        if (v2 == 0.0) {
            return 0.5;
        }
        double rx = inputPt.x - this.m_xStart;
        double ry = inputPt.y - this.m_yStart;
        double t = (rx * vx + ry * vy) / v2;
        if (!bExtrapolate) {
            if (t < 0.0) {
                t = 0.0;
            } else if (t > 1.0) {
                t = 1.0;
            }
        }
        return t;
    }

    @Override
    public int intersectionWithAxis2D(boolean b_axis_x, double ordinate, double[] result_ordinates, double[] parameters) {
        if (b_axis_x) {
            double a = this.m_yEnd - this.m_yStart;
            if (a == 0.0) {
                return ordinate == this.m_yEnd ? -1 : 0;
            }
            double t = (ordinate - this.m_yStart) / a;
            if (t < 0.0 || t > 1.0) {
                return 0;
            }
            if (result_ordinates != null) {
                result_ordinates[0] = this.getCoordX_(t);
            }
            if (parameters != null) {
                parameters[0] = t;
            }
            return 1;
        }
        double a = this.m_xEnd - this.m_xStart;
        if (a == 0.0) {
            return ordinate == this.m_xEnd ? -1 : 0;
        }
        double t = (ordinate - this.m_xStart) / a;
        if (t < 0.0 || t > 1.0) {
            return 0;
        }
        if (result_ordinates != null) {
            result_ordinates[0] = this.getCoordY_(t);
        }
        if (parameters != null) {
            parameters[0] = t;
        }
        return 1;
    }

    int intersectionWithEnvelope2D(Envelope2D clipEnv2D, boolean includeEnvBoundary, double[] segParams, double[] envelopeDistances) {
        Point2D p2;
        Point2D p1 = this.getStartXY();
        int modified = clipEnv2D.clipLine(p1, p2 = this.getEndXY(), 0, segParams, envelopeDistances);
        return modified != 0 ? 2 : 0;
    }

    @Override
    double intersectionOfYMonotonicWithAxisX(double y, double x_parallel) {
        double a = this.m_yEnd - this.m_yStart;
        if (a == 0.0) {
            return y == this.m_yEnd ? x_parallel : NumberUtils.NaN();
        }
        double t = (y - this.m_yStart) / a;
        assert (t >= 0.0 && t <= 1.0);
        double resx = this.getCoordX_(t);
        if (t == 1.0) {
            resx = this.m_xEnd;
        }
        assert (resx >= this.m_xStart && resx <= this.m_xEnd || resx <= this.m_xStart && resx >= this.m_xEnd);
        return resx;
    }

    @Override
    boolean _isIntersectingPoint(Point2D pt, double tolerance, boolean bExcludeExactEndpoints) {
        return this._intersection(pt, tolerance, bExcludeExactEndpoints) >= 0.0;
    }

    @Override
    boolean isIntersecting(Point2D pt, double tolerance) {
        return this._isIntersectingPoint(pt, tolerance, false);
    }

    void orientBottomUp_() {
        if (this.m_yEnd < this.m_yStart || this.m_yEnd == this.m_yStart && this.m_xEnd < this.m_xStart) {
            double x = this.m_xStart;
            this.m_xStart = this.m_xEnd;
            this.m_xEnd = x;
            double y = this.m_yStart;
            this.m_yStart = this.m_yEnd;
            this.m_yEnd = y;
            int n = this.m_description.getTotalComponentCount() - 2;
            for (int i = 0; i < n; ++i) {
                double a = this.m_attributes[i];
                this.m_attributes[i] = this.m_attributes[i + n];
                this.m_attributes[i + n] = a;
            }
        }
    }

    int _side(Point2D pt) {
        return this._side(pt.x, pt.y);
    }

    int _side(double ptX, double ptY) {
        Point2D v1 = new Point2D(ptX, ptY);
        v1.sub(this.getStartXY());
        Point2D v2 = new Point2D();
        v2.sub(this.getEndXY(), this.getStartXY());
        double cross = v2.crossProduct(v1);
        double crossError = 4.0 * NumberUtils.doubleEps() * (Math.abs(v2.x * v1.y) + Math.abs(v2.y * v1.x));
        return cross > crossError ? -1 : (cross < -crossError ? 1 : 0);
    }

    double _intersection(Point2D pt, double tolerance, boolean bExcludeExactEndPoints) {
        Point2D v = new Point2D();
        Point2D start = new Point2D();
        start.setCoords(this.m_xStart, this.m_yStart);
        v.sub(pt, start);
        double vlength = v.length();
        double vLengthError = vlength * 3.0 * NumberUtils.doubleEps();
        if (vlength <= Math.max(tolerance, vLengthError)) {
            assert (vlength != 0.0 || pt.isEqual(start));
            if (bExcludeExactEndPoints && vlength == 0.0) {
                return Double.NaN;
            }
            return 0.0;
        }
        Point2D end2D = this.getEndXY();
        v.sub(pt, end2D);
        vlength = v.length();
        vLengthError = vlength * 3.0 * NumberUtils.doubleEps();
        if (vlength <= Math.max(tolerance, vLengthError)) {
            assert (vlength != 0.0 || pt.isEqual(end2D));
            if (bExcludeExactEndPoints && vlength == 0.0) {
                return Double.NaN;
            }
            return 1.0;
        }
        v.setCoords(this.m_xEnd - this.m_xStart, this.m_yEnd - this.m_yStart);
        double len = v.length();
        if (len > 0.0) {
            double invertedLength = 1.0 / len;
            v.scale(invertedLength);
            Point2D relativePoint = new Point2D();
            relativePoint.sub(pt, start);
            double projection = relativePoint.dotProduct(v);
            double projectionError = 8.0 * relativePoint._dotProductAbs(v) * NumberUtils.doubleEps();
            v.leftPerpendicular();
            double distance = relativePoint.dotProduct(v);
            double distanceError = 8.0 * relativePoint._dotProductAbs(v) * NumberUtils.doubleEps();
            double perror = Math.max(tolerance, projectionError);
            if (projection < -perror || projection > len + perror) {
                return Double.NaN;
            }
            double merror = Math.max(tolerance, distanceError);
            if (Math.abs(distance) <= merror) {
                double t = projection * invertedLength;
                t = NumberUtils.snap(t, 0.0, 1.0);
                Point2D ptOnLine = new Point2D();
                this.getCoord2D(t, ptOnLine);
                if (Point2D.distance(ptOnLine, pt) <= tolerance) {
                    if (t < 0.5) {
                        if (Point2D.distance(ptOnLine, start) <= tolerance) {
                            return 0.0;
                        }
                    } else if (Point2D.distance(ptOnLine, end2D) <= tolerance) {
                        return 1.0;
                    }
                    return t;
                }
            }
        }
        return Double.NaN;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return this._equalsImpl((Segment)other);
    }

    boolean equals(Line other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Line)) {
            return false;
        }
        return this._equalsImpl(other);
    }

    boolean _projectionIntersectHelper(Line other, Point2D v, boolean bStart) {
        double dotError;
        double orgX = bStart ? this.m_xStart : this.m_xEnd;
        double orgY = bStart ? this.m_yStart : this.m_yEnd;
        Point2D m = new Point2D();
        m.x = other.getEndX() - orgX;
        m.y = other.getEndY() - orgY;
        double dot = v.dotProduct(m);
        if (dot > (dotError = 3.0 * NumberUtils.doubleEps() * v._dotProductAbs(m))) {
            double dotError2;
            m.x = other.getStartX() - orgX;
            m.y = other.getStartY() - orgY;
            double dot2 = v.dotProduct(m);
            return dot2 <= (dotError2 = 3.0 * NumberUtils.doubleEps() * v._dotProductAbs(m));
        }
        return true;
    }

    boolean _projectionIntersect(Line other) {
        Point2D v = new Point2D();
        v.x = this.m_xEnd - this.m_xStart;
        v.y = this.m_yEnd - this.m_yStart;
        if (!this._projectionIntersectHelper(other, v, false)) {
            return false;
        }
        v.negate();
        return this._projectionIntersectHelper(other, v, true);
    }

    static boolean _isIntersectingHelper(Line line1, Line line2) {
        double len2;
        int s11 = line1._side(line2.m_xStart, line2.m_yStart);
        int s12 = line1._side(line2.m_xEnd, line2.m_yEnd);
        if (s11 < 0 && s12 < 0 || s11 > 0 && s12 > 0) {
            return false;
        }
        int s21 = line2._side(line1.m_xStart, line1.m_yStart);
        int s22 = line2._side(line1.m_xEnd, line1.m_yEnd);
        if (s21 < 0 && s22 < 0 || s21 > 0 && s22 > 0) {
            return false;
        }
        double len1 = line1.calculateLength2D();
        if (len1 > (len2 = line2.calculateLength2D())) {
            return line1._projectionIntersect(line2);
        }
        return line2._projectionIntersect(line1);
    }

    static Point2D _intersectHelper1(Line line1, Line line2, double tolerance) {
        double absdet;
        Point2D result = new Point2D(NumberUtils.NaN(), NumberUtils.NaN());
        double k2x = line2.m_xEnd - line2.m_xStart;
        double k1y = line1.m_yEnd - line1.m_yStart;
        double k1x = line1.m_xEnd - line1.m_xStart;
        double k2y = line2.m_yEnd - line2.m_yStart;
        double det = k2x * k1y - k1x * k2y;
        if (det == 0.0) {
            return result;
        }
        double errdet = 4.0 * NumberUtils.doubleEps() * (Math.abs(k2x * k1y) + Math.abs(k1x * k2y));
        double by = line2.m_yStart - line1.m_yStart;
        double bx = line2.m_xStart - line1.m_xStart;
        double a0 = k2x * by - bx * k2y;
        double t0 = a0 / det;
        double a0error = 4.0 * NumberUtils.doubleEps() * (Math.abs(k2x * by) + Math.abs(bx * k2y));
        double t0error = (a0error * (absdet = Math.abs(det)) + errdet * Math.abs(a0)) / (det * det) + NumberUtils.doubleEps() * Math.abs(t0);
        if (t0 < -t0error || t0 > 1.0 + t0error) {
            return result;
        }
        double a1 = k1x * by - bx * k1y;
        double t1 = a1 / det;
        double a1error = 4.0 * NumberUtils.doubleEps() * (Math.abs(k1x * by) + Math.abs(bx * k1y));
        double t1error = (a1error * absdet + errdet * Math.abs(a1)) / (det * det) + NumberUtils.doubleEps() * Math.abs(t1);
        if (t1 < -t1error || t1 > 1.0 + t1error) {
            return result;
        }
        double t0r = NumberUtils.snap(t0, 0.0, 1.0);
        double t1r = NumberUtils.snap(t1, 0.0, 1.0);
        Point2D pt0 = line1.getCoord2D(t0r);
        Point2D pt1 = line2.getCoord2D(t1r);
        Point2D pt = new Point2D();
        pt.sub(pt0, pt1);
        if (pt.length() > tolerance) {
            pt.add(pt0, pt1);
            pt.scale(0.5);
            t0r = line1.getClosestCoordinate(pt, false);
            t1r = line2.getClosestCoordinate(pt, false);
            Point2D pt01 = line1.getCoord2D(t0r);
            Point2D pt11 = line2.getCoord2D(t1r);
            pt01.sub(pt11);
            if (pt01.length() > tolerance) {
                return result;
            }
        }
        result.setCoords(t0r, t1r);
        return result;
    }

    static int _isIntersectingLineLine(Line line1, Line line2, double tolerance, boolean bExcludeExactEndpoints) {
        int counter = 0;
        if (line1.m_xStart == line2.m_xStart && line1.m_yStart == line2.m_yStart || line1.m_xStart == line2.m_xEnd && line1.m_yStart == line2.m_yEnd) {
            ++counter;
            if (!bExcludeExactEndpoints) {
                return 1;
            }
        }
        if (line1.m_xEnd == line2.m_xStart && line1.m_yEnd == line2.m_yStart || line1.m_xEnd == line2.m_xEnd && line1.m_yEnd == line2.m_yEnd) {
            if (++counter == 2) {
                return 2;
            }
            if (!bExcludeExactEndpoints) {
                return 1;
            }
        }
        if (line2._isIntersectingPoint(line1.getStartXY(), tolerance, true)) {
            return 1;
        }
        if (line2._isIntersectingPoint(line1.getEndXY(), tolerance, true)) {
            return 1;
        }
        if (line1._isIntersectingPoint(line2.getStartXY(), tolerance, true)) {
            return 1;
        }
        if (line1._isIntersectingPoint(line2.getEndXY(), tolerance, true)) {
            return 1;
        }
        if (bExcludeExactEndpoints && counter != 0) {
            return 0;
        }
        return !Line._isIntersectingHelper(line1, line2) ? 0 : 1;
    }

    int _intersectLineLineExact(Line line1, Line line2, Point2D[] intersectionPoints, double[] param1, double[] param2) {
        int counter = 0;
        if (line1.m_xStart == line2.m_xStart && line1.m_yStart == line2.m_yStart) {
            if (param1 != null) {
                param1[counter] = 0.0;
            }
            if (param2 != null) {
                param2[counter] = 0.0;
            }
            if (intersectionPoints != null) {
                intersectionPoints[counter] = Point2D.construct(line1.m_xStart, line1.m_yStart);
            }
            ++counter;
        }
        if (line1.m_xStart == line2.m_xEnd && line1.m_yStart == line2.m_yEnd) {
            if (param1 != null) {
                param1[counter] = 0.0;
            }
            if (param2 != null) {
                param2[counter] = 1.0;
            }
            if (intersectionPoints != null) {
                intersectionPoints[counter] = Point2D.construct(line1.m_xStart, line1.m_yStart);
            }
            ++counter;
        }
        if (line1.m_xEnd == line2.m_xStart && line1.m_yEnd == line2.m_yStart) {
            if (counter == 2) {
                if (param1 != null) {
                    param1[0] = 0.0;
                    param1[1] = 1.0;
                }
                if (param2 != null) {
                    param2[0] = 1.0;
                }
                if (intersectionPoints != null) {
                    intersectionPoints[0] = Point2D.construct(line1.m_xEnd, line1.m_yEnd);
                    intersectionPoints[1] = Point2D.construct(line1.m_xEnd, line1.m_yEnd);
                }
                return counter;
            }
            if (param1 != null) {
                param1[counter] = 1.0;
            }
            if (param2 != null) {
                param2[counter] = 0.0;
            }
            if (intersectionPoints != null) {
                intersectionPoints[counter] = Point2D.construct(line1.m_xEnd, line1.m_yEnd);
            }
            ++counter;
        }
        if (line1.m_xEnd == line2.m_xEnd && line1.m_yEnd == line2.m_yEnd) {
            if (counter == 2) {
                if (param1 != null) {
                    param1[0] = 0.0;
                    param1[1] = 1.0;
                }
                if (param2 != null) {
                    param2[0] = 1.0;
                }
                if (intersectionPoints != null) {
                    intersectionPoints[0] = Point2D.construct(line1.m_xEnd, line1.m_yEnd);
                    intersectionPoints[1] = Point2D.construct(line1.m_xEnd, line1.m_yEnd);
                }
                return counter;
            }
            if (param1 != null) {
                param1[counter] = 1.0;
            }
            if (param2 != null) {
                param2[counter] = 1.0;
            }
            if (intersectionPoints != null) {
                intersectionPoints[counter] = Point2D.construct(line1.m_xEnd, line1.m_yEnd);
            }
            ++counter;
        }
        return counter;
    }

    static int _intersectLineLine(Line line1, Line line2, Point2D[] intersectionPoints, double[] param1, double[] param2, double tolerance) {
        int counter = 0;
        double t11 = line1._intersection(line2.getStartXY(), tolerance, false);
        double t12 = line1._intersection(line2.getEndXY(), tolerance, false);
        double t21 = line2._intersection(line1.getStartXY(), tolerance, false);
        double t22 = line2._intersection(line1.getEndXY(), tolerance, false);
        if (!NumberUtils.isNaN(t11)) {
            if (param1 != null) {
                param1[counter] = t11;
            }
            if (param2 != null) {
                param2[counter] = 0.0;
            }
            if (intersectionPoints != null) {
                intersectionPoints[counter] = Point2D.construct(line2.m_xStart, line2.m_yStart);
            }
            ++counter;
        }
        if (!NumberUtils.isNaN(t12)) {
            if (param1 != null) {
                param1[counter] = t12;
            }
            if (param2 != null) {
                param2[counter] = 1.0;
            }
            if (intersectionPoints != null) {
                intersectionPoints[counter] = Point2D.construct(line2.m_xEnd, line2.m_yEnd);
            }
            ++counter;
        }
        if (!(counter == 2 || NumberUtils.isNaN(t21) || t11 == 0.0 && t21 == 0.0 || t12 == 0.0 && t21 == 1.0)) {
            if (param1 != null) {
                param1[counter] = 0.0;
            }
            if (param2 != null) {
                param2[counter] = t21;
            }
            if (intersectionPoints != null) {
                intersectionPoints[counter] = Point2D.construct(line1.m_xStart, line1.m_yStart);
            }
            ++counter;
        }
        if (!(counter == 2 || NumberUtils.isNaN(t22) || t11 == 1.0 && t22 == 0.0 || t12 == 1.0 && t22 == 1.0)) {
            if (param1 != null) {
                param1[counter] = 1.0;
            }
            if (param2 != null) {
                param2[counter] = t22;
            }
            if (intersectionPoints != null) {
                intersectionPoints[counter] = Point2D.construct(line2.m_xEnd, line2.m_yEnd);
            }
            ++counter;
        }
        if (counter > 0) {
            if (counter == 2 && param1 != null && param1[0] > param1[1]) {
                double zeroParam1 = param1[0];
                param1[0] = param1[1];
                param1[1] = zeroParam1;
                if (param2 != null) {
                    double zeroParam2 = param2[0];
                    param2[0] = param2[1];
                    param2[1] = zeroParam2;
                }
                if (intersectionPoints != null) {
                    Point2D tmp = new Point2D(intersectionPoints[0].x, intersectionPoints[0].y);
                    intersectionPoints[0] = intersectionPoints[1];
                    intersectionPoints[1] = tmp;
                }
            }
            return counter;
        }
        Point2D params = Line._intersectHelper1(line1, line2, tolerance);
        if (NumberUtils.isNaN(params.x)) {
            return 0;
        }
        if (intersectionPoints != null) {
            intersectionPoints[0] = line1.getCoord2D(params.x);
        }
        if (param1 != null) {
            param1[0] = params.x;
        }
        if (param2 != null) {
            param2[0] = params.y;
        }
        return 1;
    }

    @Override
    public void replaceNaNs(int semantics, double value) {
        this.addAttribute(semantics);
        if (this.isEmpty()) {
            return;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        for (int i = 0; i < ncomps; ++i) {
            double v = this._getAttributeAsDbl(0, semantics, i);
            if (Double.isNaN(v)) {
                this._setAttribute(0, semantics, 0, value);
            }
            if (!Double.isNaN(v = this._getAttributeAsDbl(1, semantics, i))) continue;
            this._setAttribute(1, semantics, 0, value);
        }
    }

    @Override
    int getYMonotonicParts(SegmentBuffer[] monotonicSegments) {
        return 0;
    }

    @Override
    void _copyToImpl(Segment dst) {
    }

    @Override
    public String toString() {
        String s = "Line: [" + this.m_xStart + ", " + this.m_yStart + ", " + this.m_xEnd + ", " + this.m_yEnd + "]";
        return s;
    }
}

