/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.tracker;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexingRequestTracker
implements RequestTracker {
    private static final Logger LOG = LoggerFactory.getLogger(MultiplexingRequestTracker.class);
    private final List<RequestTracker> trackers = new CopyOnWriteArrayList<RequestTracker>();

    public void register(RequestTracker tracker) {
        this.trackers.add(tracker);
    }

    @Override
    public void onSuccess(@NonNull Request request, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @NonNull Node node, @NonNull String logPrefix) {
        for (RequestTracker tracker : this.trackers) {
            try {
                tracker.onSuccess(request, latencyNanos, executionProfile, node, logPrefix);
            }
            catch (Throwable t) {
                LOG.error("[{}] Unexpected error while invoking request tracker", (Object)logPrefix, (Object)t);
            }
        }
    }

    @Override
    public void onError(@NonNull Request request, @NonNull Throwable error, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @Nullable Node node, @NonNull String logPrefix) {
        for (RequestTracker tracker : this.trackers) {
            try {
                tracker.onError(request, error, latencyNanos, executionProfile, node, logPrefix);
            }
            catch (Throwable t) {
                LOG.error("[{}] Unexpected error while invoking request tracker", (Object)logPrefix, (Object)t);
            }
        }
    }

    @Override
    public void onNodeSuccess(@NonNull Request request, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @NonNull Node node, @NonNull String logPrefix) {
        for (RequestTracker tracker : this.trackers) {
            try {
                tracker.onNodeSuccess(request, latencyNanos, executionProfile, node, logPrefix);
            }
            catch (Throwable t) {
                LOG.error("[{}] Unexpected error while invoking request tracker", (Object)logPrefix, (Object)t);
            }
        }
    }

    @Override
    public void onNodeError(@NonNull Request request, @NonNull Throwable error, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @NonNull Node node, @NonNull String logPrefix) {
        for (RequestTracker tracker : this.trackers) {
            try {
                tracker.onNodeError(request, error, latencyNanos, executionProfile, node, logPrefix);
            }
            catch (Throwable t) {
                LOG.error("[{}] Unexpected error while invoking request tracker", (Object)logPrefix, (Object)t);
            }
        }
    }

    @Override
    public void onSessionReady(@NonNull Session session) {
        for (RequestTracker tracker : this.trackers) {
            try {
                tracker.onSessionReady(session);
            }
            catch (Throwable t) {
                LOG.error("[{}] Unexpected error while invoking request tracker", (Object)session.getName(), (Object)t);
            }
        }
    }

    @Override
    public void close() throws Exception {
        Exception toThrow = null;
        for (RequestTracker tracker : this.trackers) {
            try {
                tracker.close();
            }
            catch (Exception e) {
                if (toThrow == null) {
                    toThrow = e;
                    continue;
                }
                toThrow.addSuppressed(e);
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }
}

