/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.schema.validation;

import com.worldturner.medeia.api.FailedValidationResult;
import com.worldturner.medeia.api.OkValidationResult;
import com.worldturner.medeia.api.ValidationResult;
import com.worldturner.medeia.parser.JsonTokenData;
import com.worldturner.medeia.parser.JsonTokenLocation;
import com.worldturner.medeia.parser.JsonTokenType;
import com.worldturner.medeia.schema.validation.ArrayValidator;
import com.worldturner.medeia.schema.validation.SchemaValidator;
import com.worldturner.medeia.schema.validation.stream.SchemaValidatorInstance;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/worldturner/medeia/schema/validation/ArrayValidatorInstance;", "Lcom/worldturner/medeia/schema/validation/stream/SchemaValidatorInstance;", "validator", "Lcom/worldturner/medeia/schema/validation/ArrayValidator;", "startLevel", "", "(Lcom/worldturner/medeia/schema/validation/ArrayValidator;I)V", "allItemsInstance", "containsInstance", "containsMatched", "", "currentItemInstance", "first", "itemCount", "getStartLevel", "()I", "getValidator", "()Lcom/worldturner/medeia/schema/validation/ArrayValidator;", "completeValidation", "Lcom/worldturner/medeia/api/ValidationResult;", "location", "Lcom/worldturner/medeia/parser/JsonTokenLocation;", "validate", "token", "Lcom/worldturner/medeia/parser/JsonTokenData;", "medeia-validator-core"})
public final class ArrayValidatorInstance
implements SchemaValidatorInstance {
    private boolean first;
    private int itemCount;
    private boolean containsMatched;
    private SchemaValidatorInstance allItemsInstance;
    private SchemaValidatorInstance containsInstance;
    private SchemaValidatorInstance currentItemInstance;
    @NotNull
    private final ArrayValidator validator;
    private final int startLevel;

    @Override
    @Nullable
    public ValidationResult validate(@NotNull JsonTokenData token, @NotNull JsonTokenLocation location) {
        ValidationResult result;
        Object it;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        if (this.first && token.getType() != JsonTokenType.START_ARRAY) {
            return OkValidationResult.INSTANCE;
        }
        this.first = false;
        if (location.getLevel() == this.startLevel + 1 && token.getType().getFirstToken()) {
            SchemaValidator schemaValidator = this.validator.getContains();
            if (schemaValidator != null) {
                it = object = schemaValidator;
                boolean bl = false;
                this.containsInstance = it.createInstance(location.getLevel());
            }
            if (this.validator.getAllItems() != null) {
                this.allItemsInstance = this.validator.getAllItems().createInstance(location.getLevel());
            } else if (this.validator.getItems() != null) {
                if (this.itemCount < this.validator.getItems().size()) {
                    this.currentItemInstance = this.validator.getItems().get(this.itemCount).createInstance(location.getLevel());
                } else if (this.validator.getAdditionalItems() != null) {
                    this.currentItemInstance = this.validator.getAdditionalItems().createInstance(location.getLevel());
                }
            }
        }
        SchemaValidatorInstance schemaValidatorInstance = this.allItemsInstance;
        if (schemaValidatorInstance != null) {
            it = object = schemaValidatorInstance;
            boolean bl = false;
            result = it.validate(token, location);
            if (result != null) {
                if (result instanceof FailedValidationResult) {
                    return new FailedValidationResult("items", null, "Schema for all items failed to validate", location, (Collection)SetsKt.setOf((Object)result), 2, null);
                }
                this.allItemsInstance = null;
            }
        }
        SchemaValidatorInstance schemaValidatorInstance2 = this.containsInstance;
        if (schemaValidatorInstance2 != null) {
            it = object = schemaValidatorInstance2;
            boolean bl = false;
            result = it.validate(token, location);
            if (result != null) {
                if (result.getValid()) {
                    this.containsMatched = true;
                }
                this.containsInstance = null;
            }
        }
        SchemaValidatorInstance schemaValidatorInstance3 = this.currentItemInstance;
        if (schemaValidatorInstance3 != null) {
            it = object = schemaValidatorInstance3;
            boolean bl = false;
            result = it.validate(token, location);
            if (result != null) {
                if (result instanceof FailedValidationResult) {
                    Collection collection = SetsKt.setOf((Object)result);
                    String string = "Schema for items failed to validate";
                    String string2 = "items/additionalItems";
                    String string3 = null;
                    JsonTokenLocation jsonTokenLocation = location;
                    return new FailedValidationResult(string2, string3, string, jsonTokenLocation, collection, 2, null);
                }
                this.currentItemInstance = null;
            }
        }
        if (token.getType().getLastToken() && location.getLevel() == this.startLevel + 1) {
            int n = this.itemCount;
            this.itemCount = n + 1;
        }
        if (token.getType() == JsonTokenType.END_ARRAY && location.getLevel() == this.startLevel) {
            return this.completeValidation(location);
        }
        return null;
    }

    private final ValidationResult completeValidation(JsonTokenLocation location) {
        Object object;
        SchemaValidator schemaValidator = this.validator.getContains();
        if (schemaValidator != null) {
            object = schemaValidator;
            SchemaValidator it = object;
            boolean bl = false;
            if (!this.containsMatched) {
                Collection collection = null;
                String string = "Items don't contain an item that matches the 'contains' schemaValue";
                String string2 = "contains";
                String string3 = null;
                JsonTokenLocation jsonTokenLocation = location;
                return new FailedValidationResult(string2, string3, string, jsonTokenLocation, collection, 18, null);
            }
        }
        Integer n = this.validator.getMaxItems();
        if (n != null) {
            object = n;
            int it = ((Number)object).intValue();
            boolean bl = false;
            if (this.itemCount > it) {
                Collection collection = null;
                String string = "Value " + this.itemCount + " is greater than maxItems " + it;
                String string4 = "maxItems";
                String string5 = null;
                JsonTokenLocation jsonTokenLocation = location;
                return new FailedValidationResult(string4, string5, string, jsonTokenLocation, collection, 18, null);
            }
        }
        Integer n2 = this.validator.getMinItems();
        if (n2 != null) {
            object = n2;
            int it = ((Number)object).intValue();
            boolean bl = false;
            if (this.itemCount < it) {
                Collection collection = null;
                String string = "Value " + this.itemCount + " is smaller than minItems " + it;
                String string6 = "minItems";
                String string7 = null;
                JsonTokenLocation jsonTokenLocation = location;
                return new FailedValidationResult(string6, string7, string, jsonTokenLocation, collection, 18, null);
            }
        }
        return OkValidationResult.INSTANCE;
    }

    @NotNull
    public final ArrayValidator getValidator() {
        return this.validator;
    }

    public final int getStartLevel() {
        return this.startLevel;
    }

    public ArrayValidatorInstance(@NotNull ArrayValidator validator, int startLevel) {
        Intrinsics.checkParameterIsNotNull((Object)validator, (String)"validator");
        this.validator = validator;
        this.startLevel = startLevel;
        this.first = true;
    }
}

