/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.shaded.guava.common.primitives.UnsignedBytes;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class SniEndPoint
implements EndPoint {
    private static final AtomicLong OFFSET = new AtomicLong();
    private final InetSocketAddress proxyAddress;
    private final String serverName;
    private static final Comparator<InetAddress> IP_COMPARATOR = (address1, address2) -> UnsignedBytes.lexicographicalComparator().compare(address1.getAddress(), address2.getAddress());

    public SniEndPoint(InetSocketAddress proxyAddress, String serverName) {
        this.proxyAddress = Objects.requireNonNull(proxyAddress, "SNI address cannot be null");
        this.serverName = Objects.requireNonNull(serverName, "SNI Server name cannot be null");
    }

    public String getServerName() {
        return this.serverName;
    }

    @Override
    public InetSocketAddress resolve() {
        try {
            InetAddress[] aRecords = InetAddress.getAllByName(this.proxyAddress.getHostName());
            if (aRecords.length == 0) {
                throw new IllegalArgumentException("Could not resolve proxy address " + this.proxyAddress.getHostName());
            }
            Arrays.sort(aRecords, IP_COMPARATOR);
            int index = aRecords.length == 1 ? 0 : (int)OFFSET.getAndIncrement() % aRecords.length;
            return new InetSocketAddress(aRecords[index], this.proxyAddress.getPort());
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Could not resolve proxy address " + this.proxyAddress.getHostName(), e);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SniEndPoint) {
            SniEndPoint that = (SniEndPoint)other;
            return this.proxyAddress.equals(that.proxyAddress) && this.serverName.equals(that.serverName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.proxyAddress, this.serverName);
    }

    public String toString() {
        return this.proxyAddress.toString() + ":" + this.serverName;
    }

    @Override
    public String asMetricPrefix() {
        String hostString = this.proxyAddress.getHostString();
        if (hostString == null) {
            throw new IllegalArgumentException("Could not extract a host string from provided proxy address " + this.proxyAddress);
        }
        return hostString.replace('.', '_') + ':' + this.proxyAddress.getPort() + '_' + this.serverName;
    }
}

