/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.cql;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelCqlSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_CQL_PATH_BEAN_REF_CONF = "camel.sink.path.beanRef";
    public static final String CAMEL_SINK_CQL_PATH_BEAN_REF_DOC = "beanRef is defined using bean:id";
    public static final String CAMEL_SINK_CQL_PATH_BEAN_REF_DEFAULT = null;
    public static final String CAMEL_SINK_CQL_PATH_HOSTS_CONF = "camel.sink.path.hosts";
    public static final String CAMEL_SINK_CQL_PATH_HOSTS_DOC = "Hostname(s) cassansdra server(s). Multiple hosts can be separated by comma.";
    public static final String CAMEL_SINK_CQL_PATH_HOSTS_DEFAULT = null;
    public static final String CAMEL_SINK_CQL_PATH_PORT_CONF = "camel.sink.path.port";
    public static final String CAMEL_SINK_CQL_PATH_PORT_DOC = "Port number of cassansdra server(s)";
    public static final String CAMEL_SINK_CQL_PATH_PORT_DEFAULT = null;
    public static final String CAMEL_SINK_CQL_PATH_KEYSPACE_CONF = "camel.sink.path.keyspace";
    public static final String CAMEL_SINK_CQL_PATH_KEYSPACE_DOC = "Keyspace to use";
    public static final String CAMEL_SINK_CQL_PATH_KEYSPACE_DEFAULT = null;
    public static final String CAMEL_SINK_CQL_ENDPOINT_CLUSTER_NAME_CONF = "camel.sink.endpoint.clusterName";
    public static final String CAMEL_SINK_CQL_ENDPOINT_CLUSTER_NAME_DOC = "Cluster name";
    public static final String CAMEL_SINK_CQL_ENDPOINT_CLUSTER_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_CQL_ENDPOINT_CONSISTENCY_LEVEL_CONF = "camel.sink.endpoint.consistencyLevel";
    public static final String CAMEL_SINK_CQL_ENDPOINT_CONSISTENCY_LEVEL_DOC = "Consistency level to use One of: [ANY] [ONE] [TWO] [THREE] [QUORUM] [ALL] [LOCAL_ONE] [LOCAL_QUORUM] [EACH_QUORUM] [SERIAL] [LOCAL_SERIAL]";
    public static final String CAMEL_SINK_CQL_ENDPOINT_CONSISTENCY_LEVEL_DEFAULT = null;
    public static final String CAMEL_SINK_CQL_ENDPOINT_CQL_CONF = "camel.sink.endpoint.cql";
    public static final String CAMEL_SINK_CQL_ENDPOINT_CQL_DOC = "CQL query to perform. Can be overridden with the message header with key CamelCqlQuery.";
    public static final String CAMEL_SINK_CQL_ENDPOINT_CQL_DEFAULT = null;
    public static final String CAMEL_SINK_CQL_ENDPOINT_DATACENTER_CONF = "camel.sink.endpoint.datacenter";
    public static final String CAMEL_SINK_CQL_ENDPOINT_DATACENTER_DOC = "Datacenter to use";
    public static final String CAMEL_SINK_CQL_ENDPOINT_DATACENTER_DEFAULT = "datacenter1";
    public static final String CAMEL_SINK_CQL_ENDPOINT_LOAD_BALANCING_POLICY_CLASS_CONF = "camel.sink.endpoint.loadBalancingPolicyClass";
    public static final String CAMEL_SINK_CQL_ENDPOINT_LOAD_BALANCING_POLICY_CLASS_DOC = "To use a specific LoadBalancingPolicyClass";
    public static final String CAMEL_SINK_CQL_ENDPOINT_LOAD_BALANCING_POLICY_CLASS_DEFAULT = null;
    public static final String CAMEL_SINK_CQL_ENDPOINT_PASSWORD_CONF = "camel.sink.endpoint.password";
    public static final String CAMEL_SINK_CQL_ENDPOINT_PASSWORD_DOC = "Password for session authentication";
    public static final String CAMEL_SINK_CQL_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_CQL_ENDPOINT_PREPARE_STATEMENTS_CONF = "camel.sink.endpoint.prepareStatements";
    public static final String CAMEL_SINK_CQL_ENDPOINT_PREPARE_STATEMENTS_DOC = "Whether to use PreparedStatements or regular Statements";
    public static final Boolean CAMEL_SINK_CQL_ENDPOINT_PREPARE_STATEMENTS_DEFAULT = true;
    public static final String CAMEL_SINK_CQL_ENDPOINT_RESULT_SET_CONVERSION_STRATEGY_CONF = "camel.sink.endpoint.resultSetConversionStrategy";
    public static final String CAMEL_SINK_CQL_ENDPOINT_RESULT_SET_CONVERSION_STRATEGY_DOC = "To use a custom class that implements logic for converting ResultSet into message body ALL, ONE, LIMIT_10, LIMIT_100...";
    public static final String CAMEL_SINK_CQL_ENDPOINT_RESULT_SET_CONVERSION_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SINK_CQL_ENDPOINT_SESSION_CONF = "camel.sink.endpoint.session";
    public static final String CAMEL_SINK_CQL_ENDPOINT_SESSION_DOC = "To use the Session instance (you would normally not use this option)";
    public static final String CAMEL_SINK_CQL_ENDPOINT_SESSION_DEFAULT = null;
    public static final String CAMEL_SINK_CQL_ENDPOINT_USERNAME_CONF = "camel.sink.endpoint.username";
    public static final String CAMEL_SINK_CQL_ENDPOINT_USERNAME_DOC = "Username for session authentication";
    public static final String CAMEL_SINK_CQL_ENDPOINT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_CQL_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_CQL_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_CQL_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_CQL_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.cql.lazyStartProducer";
    public static final String CAMEL_SINK_CQL_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_CQL_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_CQL_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.cql.autowiredEnabled";
    public static final String CAMEL_SINK_CQL_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_CQL_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelCqlSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelCqlSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_CQL_PATH_BEAN_REF_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CQL_PATH_BEAN_REF_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_PATH_BEAN_REF_DOC);
        conf.define(CAMEL_SINK_CQL_PATH_HOSTS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CQL_PATH_HOSTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_PATH_HOSTS_DOC);
        conf.define(CAMEL_SINK_CQL_PATH_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CQL_PATH_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_PATH_PORT_DOC);
        conf.define(CAMEL_SINK_CQL_PATH_KEYSPACE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CQL_PATH_KEYSPACE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_PATH_KEYSPACE_DOC);
        conf.define(CAMEL_SINK_CQL_ENDPOINT_CLUSTER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CQL_ENDPOINT_CLUSTER_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_ENDPOINT_CLUSTER_NAME_DOC);
        conf.define(CAMEL_SINK_CQL_ENDPOINT_CONSISTENCY_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CQL_ENDPOINT_CONSISTENCY_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_ENDPOINT_CONSISTENCY_LEVEL_DOC);
        conf.define(CAMEL_SINK_CQL_ENDPOINT_CQL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CQL_ENDPOINT_CQL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_ENDPOINT_CQL_DOC);
        conf.define(CAMEL_SINK_CQL_ENDPOINT_DATACENTER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CQL_ENDPOINT_DATACENTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_ENDPOINT_DATACENTER_DOC);
        conf.define(CAMEL_SINK_CQL_ENDPOINT_LOAD_BALANCING_POLICY_CLASS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CQL_ENDPOINT_LOAD_BALANCING_POLICY_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_ENDPOINT_LOAD_BALANCING_POLICY_CLASS_DOC);
        conf.define(CAMEL_SINK_CQL_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CQL_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SINK_CQL_ENDPOINT_PREPARE_STATEMENTS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_CQL_ENDPOINT_PREPARE_STATEMENTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_ENDPOINT_PREPARE_STATEMENTS_DOC);
        conf.define(CAMEL_SINK_CQL_ENDPOINT_RESULT_SET_CONVERSION_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CQL_ENDPOINT_RESULT_SET_CONVERSION_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_ENDPOINT_RESULT_SET_CONVERSION_STRATEGY_DOC);
        conf.define(CAMEL_SINK_CQL_ENDPOINT_SESSION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CQL_ENDPOINT_SESSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_ENDPOINT_SESSION_DOC);
        conf.define(CAMEL_SINK_CQL_ENDPOINT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CQL_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SINK_CQL_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_CQL_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_CQL_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_CQL_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_CQL_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_CQL_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CQL_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}