/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicmodelzoo.nlp.embedding;

import ai.djl.inference.Predictor;
import ai.djl.modality.nlp.EmbeddingException;
import ai.djl.modality.nlp.WordEmbedding;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.nn.core.Embedding;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.TranslateException;

public class ModelZooWordEmbedding
implements WordEmbedding,
AutoCloseable {
    private ZooModel<NDList, NDList> model;
    private Predictor<NDList, NDList> predictor;
    private Embedding<String> embedding;
    private String unknownToken;

    public ModelZooWordEmbedding(ZooModel<NDList, NDList> model) {
        this.model = model;
        this.unknownToken = model.getProperty("unknownToken");
        this.predictor = model.newPredictor();
        try {
            this.embedding = (Embedding)model.getBlock();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("The model was not an embedding", e);
        }
    }

    public boolean vocabularyContains(String word) {
        return this.embedding.hasItem((Object)word);
    }

    public NDArray preprocessWordToEmbed(NDManager manager, String word) {
        if (this.embedding.hasItem((Object)word)) {
            return this.embedding.embed(manager, (Object)word);
        }
        return this.embedding.embed(manager, (Object)this.unknownToken);
    }

    public NDArray embedWord(NDArray word) throws EmbeddingException {
        try {
            return ((NDList)this.predictor.predict((Object)new NDList(new NDArray[]{word}))).singletonOrThrow();
        }
        catch (TranslateException e) {
            throw new EmbeddingException("Could not embed word", (Throwable)e);
        }
    }

    public String unembedWord(NDArray word) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void close() {
        this.predictor.close();
        this.model.close();
    }
}

