/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.djl.DJLComponent;
import org.apache.camel.component.djl.DJLProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="3.3.0", scheme="djl", title="Deep Java Library", syntax="djl:application", label="ai,deeplearning", producerOnly=true)
public class DJLEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true, description="Application name")
    private String application;
    @UriParam(description="Model Artifact")
    private String artifactId;
    @UriParam(description="Model")
    private String model;
    @UriParam(description="Translator")
    private String translator;

    public DJLEndpoint(String uri, DJLComponent component, String application) {
        super(uri, (Component)component);
        this.application = application;
    }

    public Producer createProducer() throws Exception {
        return new DJLProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getTranslator() {
        return this.translator;
    }

    public void setTranslator(String translator) {
        this.translator = translator;
    }
}

