/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.camel.Exchange;
import org.apache.camel.component.djl.model.AbstractPredictor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomObjectDetectionPredictor
extends AbstractPredictor {
    private static final Logger LOG = LoggerFactory.getLogger(CustomObjectDetectionPredictor.class);
    private final String modelName;
    private final String translatorName;

    public CustomObjectDetectionPredictor(String modelName, String translatorName) {
        this.modelName = modelName;
        this.translatorName = translatorName;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Model model = (Model)exchange.getContext().getRegistry().lookupByNameAndType(this.modelName, Model.class);
        Translator translator = (Translator)exchange.getContext().getRegistry().lookupByNameAndType(this.translatorName, Translator.class);
        if (exchange.getIn().getBody() instanceof byte[]) {
            byte[] bytes = (byte[])exchange.getIn().getBody(byte[].class);
            DetectedObjects result = this.classify(model, translator, new ByteArrayInputStream(bytes));
            exchange.getIn().setBody((Object)result);
        } else if (exchange.getIn().getBody() instanceof File) {
            DetectedObjects result = this.classify(model, translator, (File)exchange.getIn().getBody(File.class));
            exchange.getIn().setBody((Object)result);
        } else if (exchange.getIn().getBody() instanceof InputStream) {
            DetectedObjects result = this.classify(model, translator, (InputStream)exchange.getIn().getBody(InputStream.class));
            exchange.getIn().setBody((Object)result);
        } else {
            throw new RuntimeException("Data type is not supported. Body should be byte[], InputStream or File");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DetectedObjects classify(Model model, Translator translator, BufferedImage input) throws Exception {
        try (Predictor predictor = model.newPredictor(translator);){
            DetectedObjects detectedObjects;
            DetectedObjects detectedObjects2 = detectedObjects = (DetectedObjects)predictor.predict((Object)input);
            return detectedObjects2;
        }
        catch (TranslateException e) {
            LOG.error("Could not process input or output", (Throwable)e);
            throw new RuntimeException("Could not process input or output", e);
        }
    }

    public DetectedObjects classify(Model model, Translator translator, File input) throws Exception {
        try {
            return this.classify(model, translator, ImageIO.read(input));
        }
        catch (IOException e) {
            LOG.error("Couldn't transform input into a BufferedImage");
            throw new RuntimeException("Couldn't transform input into a BufferedImage", e);
        }
    }

    public DetectedObjects classify(Model model, Translator translator, InputStream input) throws Exception {
        try {
            return this.classify(model, translator, ImageIO.read(input));
        }
        catch (IOException e) {
            LOG.error("Couldn't transform input into a BufferedImage");
            throw new RuntimeException("Couldn't transform input into a BufferedImage", e);
        }
    }
}

