/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.Model;
import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.modality.cv.translator.ImageTranslator;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SingleShotDetectionTranslator
extends ImageTranslator<DetectedObjects> {
    protected float threshold;
    protected String synsetArtifactName;
    protected List<String> classes;
    private double imageWidth;
    private double imageHeight;

    public SingleShotDetectionTranslator(Builder builder) {
        super(builder);
        this.threshold = builder.threshold;
        this.synsetArtifactName = builder.synsetArtifactName;
        this.classes = builder.classes;
        this.imageWidth = builder.imageWidth;
        this.imageHeight = builder.imageHeight;
    }

    @Override
    public void prepare(NDManager manager, Model model) throws IOException {
        if (this.classes == null) {
            this.classes = model.getArtifact(this.synsetArtifactName, Utils::readLines);
        }
    }

    @Override
    public DetectedObjects processOutput(TranslatorContext ctx, NDList list) throws IOException {
        float[] classIds = ((NDArray)list.get(0)).toFloatArray();
        float[] probabilities = ((NDArray)list.get(1)).toFloatArray();
        NDArray boundingBoxes = (NDArray)list.get(2);
        ArrayList<String> retNames = new ArrayList<String>();
        ArrayList<Double> retProbs = new ArrayList<Double>();
        ArrayList<BoundingBox> retBB = new ArrayList<BoundingBox>();
        for (int i = 0; i < classIds.length; ++i) {
            int classId = (int)classIds[i];
            double probability = probabilities[i];
            if (classId < 0 || !(probability > (double)this.threshold)) continue;
            if (classId >= this.classes.size()) {
                throw new AssertionError((Object)("Unexpected index: " + classId));
            }
            String className = this.classes.get(classId);
            float[] box = boundingBoxes.get(i).toFloatArray();
            double x = this.imageWidth > 0.0 ? (double)box[0] / this.imageWidth : (double)box[0];
            double y = this.imageHeight > 0.0 ? (double)box[1] / this.imageHeight : (double)box[1];
            double w = this.imageWidth > 0.0 ? (double)box[2] / this.imageWidth - x : (double)box[2] - x;
            double h = this.imageHeight > 0.0 ? (double)box[3] / this.imageHeight - y : (double)box[3] - y;
            Rectangle rect = new Rectangle(x, y, w, h);
            retNames.add(className);
            retProbs.add(probability);
            retBB.add(rect);
        }
        return new DetectedObjects(retNames, retProbs, retBB);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImageTranslator.BaseBuilder<Builder> {
        private float threshold = 0.2f;
        private String synsetArtifactName;
        private List<String> classes;
        private double imageWidth;
        private double imageHeight;

        public Builder optThreshold(float threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder setSynsetArtifactName(String synsetArtifactName) {
            this.synsetArtifactName = synsetArtifactName;
            return this;
        }

        public Builder setClasses(List<String> classes) {
            this.classes = classes;
            return this;
        }

        public Builder optRescaleSize(double imageWidth, double imageHeight) {
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public SingleShotDetectionTranslator build() {
            if (this.synsetArtifactName == null && this.classes == null) {
                throw new IllegalArgumentException("You must specify a synset artifact name or classes");
            }
            if (this.synsetArtifactName != null && this.classes != null) {
                throw new IllegalArgumentException("You can only specify one of: synset artifact name or classes");
            }
            return new SingleShotDetectionTranslator(this);
        }

        public float getThreshold() {
            return this.threshold;
        }

        public String getSynsetArtifactName() {
            return this.synsetArtifactName;
        }

        public List<String> getClasses() {
            return this.classes;
        }

        public double getImageWidth() {
            return this.imageWidth;
        }

        public double getImageHeight() {
            return this.imageHeight;
        }
    }
}

