/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.nn.recurrent;

import ai.djl.nn.recurrent.RecurrentCell;

public class RNN
extends RecurrentCell {
    RNN(Builder builder) {
        super(builder);
        this.mode = builder.activation == Activation.RELU ? "rnn_relu" : "rnn_tanh";
        this.gates = 1;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Activation {
        RELU,
        TANH;

    }

    public static final class Builder
    extends RecurrentCell.BaseBuilder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        public Builder setActivation(Activation activation) {
            this.activation = activation;
            return this.self();
        }

        public RNN build() {
            if (this.stateSize == -1L || this.numStackedLayers == -1) {
                throw new IllegalArgumentException("Must set stateSize and numStackedLayers");
            }
            return new RNN(this);
        }
    }
}

