/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.AbstractRepository;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.repository.VersionRange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class LocalRepository
extends AbstractRepository {
    private String name;
    private Path path;

    public LocalRepository(Path path) {
        this(path.toFile().getName(), path);
    }

    public LocalRepository(String name, Path path) {
        this.name = name;
        this.path = path;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getBaseUri() {
        return this.path.toUri();
    }

    @Override
    public Metadata locate(MRL mrl) throws IOException {
        URI uri = mrl.toURI();
        Path base = this.path.resolve(uri.getPath());
        Path file = base.resolve("metadata.json");
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(file);){
            Metadata metadata = (Metadata)GSON.fromJson((Reader)reader, Metadata.class);
            metadata.setRepositoryUri(uri);
            Metadata metadata2 = metadata;
            return metadata2;
        }
    }

    @Override
    public Artifact resolve(MRL mrl, String version, Map<String, String> filter) throws IOException {
        VersionRange range;
        Metadata metadata = this.locate(mrl);
        List<Artifact> artifacts = metadata.search(range = VersionRange.parse(version), filter);
        if (artifacts.isEmpty()) {
            return null;
        }
        return artifacts.get(0);
    }
}

