/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.repository.Artifact;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.repository.zoo.ZooProvider;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;

public interface ModelZoo {
    public String getGroupId();

    default public List<ModelLoader<?, ?>> getModelLoaders() {
        ArrayList list = new ArrayList();
        try {
            Field[] fields;
            for (Field field : fields = this.getClass().getDeclaredFields()) {
                if (!ModelLoader.class.isAssignableFrom(field.getType())) continue;
                list.add((ModelLoader)field.get(null));
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return list;
    }

    default public ModelLoader<?, ?> getModelLoader(String name) {
        for (ModelLoader<?, ?> loader : this.getModelLoaders()) {
            if (!name.equals(loader.getArtifactId())) continue;
            return loader;
        }
        return null;
    }

    public Set<String> getSupportedEngines();

    public static <I, O> ZooModel<I, O> loadModel(Criteria<I, O> criteria) throws IOException, ModelNotFoundException, MalformedModelException {
        String groupId = criteria.getGroupId();
        ServiceLoader<ZooProvider> providers = ServiceLoader.load(ZooProvider.class);
        for (ZooProvider provider : providers) {
            Set<String> supportedEngine;
            ModelZoo zoo = provider.getModelZoo();
            if (zoo == null || groupId != null && !zoo.getGroupId().equals(groupId) || !(supportedEngine = zoo.getSupportedEngines()).contains(criteria.getEngine())) continue;
            Application application = criteria.getApplication();
            String artifactId = criteria.getArtifactId();
            for (ModelLoader<?, ?> loader : zoo.getModelLoaders()) {
                if (artifactId != null && !artifactId.equals(loader.getArtifactId())) continue;
                Application app = loader.getApplication();
                if (application != null && app != null && !app.equals(application)) continue;
                try {
                    return loader.loadModel(criteria);
                }
                catch (ModelNotFoundException modelNotFoundException) {
                }
            }
        }
        throw new ModelNotFoundException("No matching model with specified Input/Output type found.");
    }

    public static Map<Application, List<Artifact>> listModels() throws IOException, ModelNotFoundException {
        TreeMap<Application, List<Artifact>> models = new TreeMap<Application, List<Artifact>>(Comparator.comparing(Application::getPath));
        ServiceLoader<ZooProvider> providers = ServiceLoader.load(ZooProvider.class);
        for (ZooProvider provider : providers) {
            ModelZoo zoo = provider.getModelZoo();
            if (zoo == null) continue;
            List<ModelLoader<?, ?>> list = zoo.getModelLoaders();
            for (ModelLoader<?, ?> loader : list) {
                Application app = loader.getApplication();
                List<Artifact> artifacts = loader.listModels();
                models.compute(app, (key, val) -> {
                    if (val == null) {
                        val = new ArrayList();
                    }
                    val.addAll(artifacts);
                    return val;
                });
            }
        }
        return models;
    }
}

