/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.Block;
import ai.djl.training.Trainer;
import ai.djl.training.TrainingConfig;
import ai.djl.translate.Translator;
import ai.djl.util.PairList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;

public class ZooModel<I, O>
implements Model {
    private Model model;
    private Translator<I, O> translator;

    public ZooModel(Model model, Translator<I, O> translator) {
        this.model = model;
        this.translator = translator;
    }

    public void load(Path modelPath, String modelName, Map<String, String> options) {
        throw new IllegalArgumentException("ZooModel should not be re-loaded.");
    }

    public void save(Path modelPath, String modelName) throws IOException {
        this.model.save(modelPath, modelName);
    }

    public Block getBlock() {
        return this.model.getBlock();
    }

    public void setBlock(Block block) {
        this.model.setBlock(block);
    }

    public String getName() {
        return this.model.getName();
    }

    public String getProperty(String key) {
        return this.model.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.model.setProperty(key, value);
    }

    public Trainer newTrainer(TrainingConfig trainingConfig) {
        return this.model.newTrainer(trainingConfig);
    }

    public Predictor<I, O> newPredictor() {
        return this.newPredictor(this.translator);
    }

    public <P, Q> Predictor<P, Q> newPredictor(Translator<P, Q> translator) {
        return this.model.newPredictor(translator);
    }

    public Translator<I, O> getTranslator() {
        return this.translator;
    }

    public PairList<String, Shape> describeInput() {
        return this.model.describeInput();
    }

    public PairList<String, Shape> describeOutput() {
        return this.model.describeOutput();
    }

    public String[] getArtifactNames() {
        return this.model.getArtifactNames();
    }

    public <T> T getArtifact(String name, Function<InputStream, T> function) throws IOException {
        return (T)this.model.getArtifact(name, function);
    }

    public URL getArtifact(String name) throws IOException {
        return this.model.getArtifact(name);
    }

    public InputStream getArtifactAsStream(String name) throws IOException {
        return this.model.getArtifactAsStream(name);
    }

    public NDManager getNDManager() {
        return this.model.getNDManager();
    }

    public void setDataType(DataType dataType) {
        this.model.setDataType(dataType);
    }

    public DataType getDataType() {
        return this.model.getDataType();
    }

    public void cast(DataType dataType) {
        this.model.cast(dataType);
    }

    public void close() {
        this.model.close();
    }
}

