/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.zoo.nlp.embedding;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.nn.Block;
import ai.djl.nn.core.Embedding;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import ai.djl.util.Progress;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GloveWordEmbeddingModelLoader
extends BaseModelLoader<NDList, NDList> {
    private static final Application APPLICATION = Application.NLP.WORD_EMBEDDING;
    private static final String GROUP_ID = "ai.djl.mxnet";
    private static final String ARTIFACT_ID = "glove";
    private static final String VERSION = "0.0.1";

    public GloveWordEmbeddingModelLoader(Repository repository) {
        super(repository, MRL.model((Application)APPLICATION, (String)GROUP_ID, (String)ARTIFACT_ID), VERSION);
        this.factories.put(new Pair(String.class, NDList.class), new FactoryImpl());
    }

    public Application getApplication() {
        return APPLICATION;
    }

    protected Model createModel(Device device, Artifact artifact, Map<String, Object> arguments) throws IOException {
        Model model = Model.newInstance((Device)device);
        List idxToToken = Utils.readLines((InputStream)this.repository.openStream((Artifact.Item)artifact.getFiles().get("idx_to_token"), null));
        Embedding embedding = Embedding.builder().setType(String.class).setEmbeddingSize(Integer.parseInt((String)artifact.getProperties().get("dimensions"))).setItems((Collection)idxToToken).optUseDefault(false).build();
        model.setBlock((Block)embedding);
        model.setProperty("unknownToken", (String)arguments.get("unknownToken"));
        return model;
    }

    public ZooModel<NDList, NDList> loadModel(Map<String, String> filters, Device device, Progress progress) throws IOException, ModelNotFoundException, MalformedModelException {
        Criteria criteria = Criteria.builder().setTypes(NDList.class, NDList.class).optApplication(Application.NLP.WORD_EMBEDDING).optFilters(filters).optDevice(device).optProgress(progress).build();
        return this.loadModel(criteria);
    }

    private static final class TranslatorImpl
    implements Translator<String, NDList> {
        private String unknownToken;
        private Embedding<String> embedding;

        public TranslatorImpl(String unknownToken) {
            this.unknownToken = unknownToken;
        }

        public void prepare(NDManager manager, Model model) throws IOException {
            try {
                this.embedding = (Embedding)model.getBlock();
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("The model was not an embedding", e);
            }
        }

        public NDList processOutput(TranslatorContext ctx, NDList list) throws Exception {
            return list;
        }

        public NDList processInput(TranslatorContext ctx, String input) throws Exception {
            if (this.embedding.hasItem((Object)input)) {
                return new NDList(new NDArray[]{this.embedding.embed(ctx.getNDManager(), (Object)input)});
            }
            return new NDList(new NDArray[]{this.embedding.embed(ctx.getNDManager(), (Object)this.unknownToken)});
        }
    }

    private static final class FactoryImpl
    implements TranslatorFactory<String, NDList> {
        private FactoryImpl() {
        }

        public Translator<String, NDList> newInstance(Map<String, Object> arguments) {
            String unknownToken = (String)arguments.get("unknownToken");
            return new TranslatorImpl(unknownToken);
        }
    }
}

