/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.Artifact;
import ai.djl.repository.Hex;
import ai.djl.repository.Metadata;
import ai.djl.repository.Repository;
import ai.djl.repository.ZipUtils;
import ai.djl.util.Progress;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public abstract class AbstractRepository
implements Repository {
    @Override
    public InputStream openStream(Artifact.Item item, String path) throws IOException {
        return Files.newInputStream(Paths.get(this.resolvePath(item, path)), new OpenOption[0]);
    }

    @Override
    public String[] listDirectory(Artifact.Item item, String path) throws IOException {
        return Paths.get(this.resolvePath(item, path)).toFile().list();
    }

    @Override
    public Path getFile(Artifact.Item item, String path) throws IOException {
        return Paths.get(this.resolvePath(item, path)).toAbsolutePath();
    }

    protected URI resolvePath(Artifact.Item item, String path) throws IOException {
        Artifact artifact = item.getArtifact();
        URI artifactUri = artifact.getResourceUri();
        String itemUri = item.getUri();
        if (itemUri != null && URI.create(itemUri).isAbsolute() || this.isRemote()) {
            Path cacheDir = this.getCacheDirectory();
            Path resourceDir = cacheDir.resolve(artifactUri.getPath());
            String type = item.getType();
            String fileName = item.getName();
            if ("dir".equals(type)) {
                Path cachedFile = !fileName.isEmpty() ? resourceDir.resolve(fileName) : resourceDir;
                return cachedFile.resolve(path).toUri();
            }
            return resourceDir.resolve(fileName).toUri();
        }
        String uriSuffix = itemUri != null ? itemUri : item.getName();
        return this.getBaseUri().resolve(artifactUri.resolve(uriSuffix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(Artifact artifact, Progress progress) throws IOException {
        URI resourceUri;
        Path cacheDir = this.getCacheDirectory();
        Path resourceDir = cacheDir.resolve((resourceUri = artifact.getResourceUri()).getPath());
        if (Files.exists(resourceDir, new LinkOption[0])) {
            return;
        }
        Metadata metadata = artifact.getMetadata();
        URI baseUri = metadata.getRepositoryUri();
        Map<String, Artifact.Item> files = artifact.getFiles();
        Path parentDir = resourceDir.toAbsolutePath().getParent();
        if (parentDir == null) {
            throw new AssertionError((Object)("Parent path should never be null: " + resourceDir.toString()));
        }
        Files.createDirectories(parentDir, new FileAttribute[0]);
        Path tmp = Files.createTempDirectory(parentDir, resourceDir.toFile().getName(), new FileAttribute[0]);
        if (progress != null) {
            long totalSize = 0L;
            for (Artifact.Item item : files.values()) {
                totalSize += item.getSize();
            }
            progress.reset("Downloading", totalSize);
        }
        try {
            for (Artifact.Item item : files.values()) {
                this.download(tmp, baseUri, item, progress);
            }
            Files.move(tmp, resourceDir, StandardCopyOption.ATOMIC_MOVE);
        }
        finally {
            Utils.deleteQuietly((Path)tmp);
            if (progress != null) {
                progress.end();
            }
        }
    }

    @Override
    public Path getCacheDirectory() throws IOException {
        Path dir;
        String cacheDir = System.getProperty("DJL_CACHE_DIR");
        if ((cacheDir == null || cacheDir.isEmpty()) && ((cacheDir = System.getenv("DJL_CACHE_DIR")) == null || cacheDir.isEmpty())) {
            String userHome = System.getProperty("user.home");
            cacheDir = userHome + "/.djl.ai/cache";
        }
        if (Files.notExists(dir = Paths.get(cacheDir, "repo"), new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Failed initialize cache directory: " + dir.toString());
        }
        return dir;
    }

    private void download(Path tmp, URI baseUri, Artifact.Item item, Progress progress) throws IOException {
        URI fileUri = URI.create(item.getUri());
        if (!fileUri.isAbsolute()) {
            fileUri = this.getBaseUri().resolve(baseUri).resolve(fileUri);
        }
        try (InputStream is = fileUri.toURL().openStream();){
            ProgressInputStream pis = new ProgressInputStream(is, progress);
            String fileName = item.getName();
            String extension = item.getExtension();
            if ("dir".equals(item.getType())) {
                Path dir;
                if (!fileName.isEmpty()) {
                    dir = tmp.resolve(fileName);
                    Files.createDirectories(dir, new FileAttribute[0]);
                } else {
                    dir = tmp;
                }
                if (!"zip".equals(extension)) {
                    throw new IOException("File type is not supported: " + extension);
                }
                ZipUtils.unzip(pis, dir);
            } else {
                Path file = tmp.resolve(fileName);
                if ("zip".equals(extension)) {
                    ZipInputStream zis = new ZipInputStream(pis);
                    zis.getNextEntry();
                    Files.copy(zis, file, new CopyOption[0]);
                } else if ("gzip".equals(extension)) {
                    Files.copy(new GZIPInputStream(pis), file, new CopyOption[0]);
                } else if (extension.isEmpty()) {
                    Files.copy(pis, file, new CopyOption[0]);
                } else {
                    throw new IOException("File type is not supported: " + extension);
                }
            }
            pis.validateChecksum(item);
        }
    }

    private static final class ProgressInputStream
    extends InputStream {
        private DigestInputStream dis;
        private Progress progress;

        public ProgressInputStream(InputStream is, Progress progress) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError("SHA1 algorithm not found.", e);
            }
            this.dis = new DigestInputStream(is, md);
            this.progress = progress;
        }

        @Override
        public int read() throws IOException {
            int ret = this.dis.read();
            if (this.progress != null) {
                if (ret >= 0) {
                    this.progress.increment(1L);
                } else {
                    this.progress.end();
                }
            }
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int size = this.dis.read(b, off, len);
            if (this.progress != null) {
                this.progress.increment((long)size);
            }
            return size;
        }

        private void validateChecksum(Artifact.Item item) throws IOException {
            Utils.toByteArray((InputStream)this.dis);
            String sha1 = Hex.toHexString(this.dis.getMessageDigest().digest());
            if (!sha1.equalsIgnoreCase(item.getSha1Hash())) {
                throw new IOException("Checksum error: " + item.getName() + ", expected sha1: " + item.getSha1Hash() + ", actual sha1: " + sha1);
            }
        }

        @Override
        public void close() throws IOException {
            this.dis.close();
        }
    }
}

