/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.Artifact;
import ai.djl.repository.VersionRange;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Metadata {
    private String metadataVersion;
    private String groupId;
    private String artifactId;
    private String name;
    private String description;
    private String website;
    private List<Artifact> artifacts;
    private String checksum;
    private Date lastUpdated;
    private transient URI repositoryUri;

    public List<Artifact> search(VersionRange versionRange, Map<String, String> filter) {
        List<Artifact> results = versionRange.matches(this.artifacts);
        if (filter == null) {
            return results;
        }
        return results.stream().filter(a -> a.hasProperties(filter)).collect(Collectors.toList());
    }

    public String getMetadataVersion() {
        return this.metadataVersion;
    }

    public void setMetadataVersion(String metadataVersion) {
        this.metadataVersion = metadataVersion;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<Artifact> artifacts) {
        this.artifacts = artifacts;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public URI getRepositoryUri() {
        return this.repositoryUri;
    }

    public void setRepositoryUri(URI repositoryUri) {
        this.repositoryUri = repositoryUri;
        if (this.artifacts != null) {
            for (Artifact artifact : this.artifacts) {
                artifact.setMetadata(this);
            }
        }
    }
}

