/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.AbstractRepository;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.util.Progress;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleRepository
extends AbstractRepository {
    private String name;
    private Path path;

    public SimpleRepository(Path path) {
        this(path.toFile().getName(), path);
    }

    public SimpleRepository(String name, Path path) {
        this.name = name;
        this.path = path;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getBaseUri() {
        return this.path.toUri();
    }

    @Override
    public Metadata locate(MRL mrl) throws IOException {
        Metadata metadata = new Metadata();
        metadata.setRepositoryUri(URI.create(""));
        Artifact artifact = new Artifact();
        artifact.setMetadata(metadata);
        metadata.setArtifacts(Collections.singletonList(artifact));
        artifact.setName(this.name);
        ConcurrentHashMap<String, Artifact.Item> files = new ConcurrentHashMap<String, Artifact.Item>();
        File[] fileList = this.path.toFile().listFiles();
        if (fileList == null) {
            throw new IllegalArgumentException("No files found in SimpleRepository");
        }
        for (File file : fileList) {
            Artifact.Item item = new Artifact.Item();
            item.setName(file.getName());
            item.setSize(file.length());
            item.setArtifact(artifact);
            files.put(file.getName(), item);
        }
        artifact.setFiles(files);
        return metadata;
    }

    @Override
    public Artifact resolve(MRL mrl, String version, Map<String, String> filter) throws IOException {
        return this.locate(mrl).getArtifacts().get(0);
    }

    @Override
    public void prepare(Artifact artifact, Progress progress) {
    }

    @Override
    public Path getCacheDirectory() {
        return this.path;
    }

    @Override
    protected URI resolvePath(Artifact.Item item, String path) throws IOException {
        return this.path.resolve(item.getName()).toUri();
    }
}

