/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.Artifact;
import ai.djl.repository.LocalRepository;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.repository.RemoteRepository;
import ai.djl.repository.SimpleRepository;
import ai.djl.util.Progress;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Repository {
    public static final Gson GSON = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").setPrettyPrinting().create();

    public static Repository newInstance(String name, String url) {
        String scheme;
        Logger logger = LoggerFactory.getLogger(Repository.class);
        URI uri = URI.create(url);
        Path path = null;
        if (!uri.isAbsolute()) {
            path = Paths.get(url, new String[0]);
        }
        if ("file".equalsIgnoreCase(scheme = uri.getScheme())) {
            path = Paths.get(uri.getPath(), new String[0]);
        }
        if (path != null) {
            boolean isLocal;
            try {
                isLocal = Files.walk(path, new FileVisitOption[0]).anyMatch(f -> "metadata.json".equals(f.toFile().getName()) && f.toFile().isFile());
            }
            catch (IOException e) {
                isLocal = false;
                logger.warn("Failed determining if local or naked repository. Defaulting to naked", (Throwable)e);
            }
            if (isLocal) {
                return new LocalRepository(name, path);
            }
            return new SimpleRepository(name, path);
        }
        return new RemoteRepository(name, uri);
    }

    public boolean isRemote();

    public String getName();

    public URI getBaseUri();

    public Metadata locate(MRL var1) throws IOException;

    public Artifact resolve(MRL var1, String var2, Map<String, String> var3) throws IOException;

    public InputStream openStream(Artifact.Item var1, String var2) throws IOException;

    public Path getFile(Artifact.Item var1, String var2) throws IOException;

    public String[] listDirectory(Artifact.Item var1, String var2) throws IOException;

    default public void prepare(Artifact artifact) throws IOException {
        this.prepare(artifact, null);
    }

    public void prepare(Artifact var1, Progress var2) throws IOException;

    public Path getCacheDirectory() throws IOException;
}

