/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static void unzip(InputStream is, Path dest) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            Path file = dest.resolve(name).toAbsolutePath();
            if (entry.isDirectory()) {
                Files.createDirectories(file, new FileAttribute[0]);
                continue;
            }
            Path parentFile = file.getParent();
            if (parentFile == null) {
                throw new AssertionError((Object)("Parent path should never be null: " + file.toString()));
            }
            Files.createDirectories(parentFile, new FileAttribute[0]);
            Files.copy(zis, file, new CopyOption[0]);
        }
    }
}

