/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.ndarray.NDList;
import ai.djl.repository.Artifact;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.NoopTranslator;
import ai.djl.util.Progress;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LocalModelLoader
implements ModelLoader<NDList, NDList> {
    private Repository repository;

    public LocalModelLoader(Repository repository) {
        this.repository = repository;
    }

    @Override
    public String getArtifactId() {
        return this.repository.getName();
    }

    @Override
    public Application getApplication() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, T> ZooModel<S, T> loadModel(Criteria<S, T> criteria) throws IOException, ModelNotFoundException, MalformedModelException {
        Progress progress = criteria.getProgress();
        try {
            NoopTranslator translator = criteria.getTranslator();
            if (translator == null) {
                translator = new NoopTranslator();
            }
            if (progress != null) {
                progress.reset("Loading", 2L);
                progress.update(1L);
            }
            Path dir = this.repository.getCacheDirectory();
            Model model = Model.newInstance((Device)criteria.getDevice());
            model.load(dir);
            ZooModel zooModel = new ZooModel(model, translator);
            return zooModel;
        }
        finally {
            if (progress != null) {
                progress.end();
            }
        }
    }

    @Override
    public ZooModel<NDList, NDList> loadModel(Map<String, String> filters, Device device, Progress progress) throws IOException, ModelNotFoundException, MalformedModelException {
        Criteria<NDList, NDList> criteria = Criteria.builder().setTypes(NDList.class, NDList.class).optFilters(filters).optDevice(device).optProgress(progress).build();
        return this.loadModel(criteria);
    }

    @Override
    public List<Artifact> listModels() {
        return Collections.emptyList();
    }
}

