/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.engine.Engine;
import ai.djl.repository.SimpleRepository;
import ai.djl.repository.zoo.LocalModelLoader;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelZoo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalModelZoo
implements ModelZoo {
    private static final Logger logger = LoggerFactory.getLogger(LocalModelZoo.class);
    public static final String GROUP_ID = "ai.djl.localmodelzoo";
    private Path folder;

    public LocalModelZoo(Path folder) {
        this.folder = folder;
    }

    @Override
    public List<ModelLoader<?, ?>> getModelLoaders() {
        try {
            List dirs = Files.list(this.folder).filter(p -> Files.isDirectory(p, new LinkOption[0])).collect(Collectors.toList());
            if (dirs.isEmpty()) {
                LocalModelLoader loader = new LocalModelLoader(new SimpleRepository(this.folder));
                return Collections.singletonList(loader);
            }
            ArrayList loaders = new ArrayList();
            for (Path p2 : dirs) {
                loaders.add(new LocalModelLoader(new SimpleRepository(p2)));
            }
            return loaders;
        }
        catch (IOException e) {
            logger.error("Failed list files.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public String getGroupId() {
        return GROUP_ID;
    }

    @Override
    public Set<String> getSupportedEngines() {
        return Collections.singleton(Engine.getInstance().getEngineName());
    }
}

