/*
 * Decompiled with CFR 0.152.
 */
package ai.djl;

import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.Block;
import ai.djl.training.Trainer;
import ai.djl.training.TrainingConfig;
import ai.djl.translate.Translator;
import ai.djl.util.PairList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;

public interface Model
extends AutoCloseable {
    public static Model newInstance() {
        return Model.newInstance(Device.defaultDevice());
    }

    public static Model newInstance(Device device) {
        return Engine.getInstance().newModel(device);
    }

    public static Model newInstance(Device device, String engineName) {
        return Engine.getEngine(engineName).newModel(device);
    }

    default public void load(Path modelPath) throws IOException, MalformedModelException {
        this.load(modelPath, modelPath.toFile().getName(), null);
    }

    default public void load(Path modelPath, String modelName) throws IOException, MalformedModelException {
        this.load(modelPath, modelName, null);
    }

    public void load(Path var1, String var2, Map<String, String> var3) throws IOException, MalformedModelException;

    public void save(Path var1, String var2) throws IOException;

    public Block getBlock();

    public void setBlock(Block var1);

    public String getName();

    public String getProperty(String var1);

    public void setProperty(String var1, String var2);

    public NDManager getNDManager();

    public Trainer newTrainer(TrainingConfig var1);

    public <I, O> Predictor<I, O> newPredictor(Translator<I, O> var1);

    public PairList<String, Shape> describeInput();

    public PairList<String, Shape> describeOutput();

    public String[] getArtifactNames();

    public <T> T getArtifact(String var1, Function<InputStream, T> var2) throws IOException;

    public URL getArtifact(String var1) throws IOException;

    public InputStream getArtifactAsStream(String var1) throws IOException;

    public void setDataType(DataType var1);

    public DataType getDataType();

    public void cast(DataType var1);

    default public void quantize() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void close();
}

