/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray.internal;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.Activation;
import ai.djl.nn.pooling.PoolingConvention;
import ai.djl.util.PairList;
import java.util.List;

public interface NDArrayEx {
    public NDArray rdiv(Number var1);

    public NDArray rdiv(NDArray var1);

    public NDArray rdivi(Number var1);

    public NDArray rdivi(NDArray var1);

    public NDArray rsub(Number var1);

    public NDArray rsub(NDArray var1);

    public NDArray rsubi(Number var1);

    public NDArray rsubi(NDArray var1);

    public NDArray rmod(Number var1);

    public NDArray rmod(NDArray var1);

    public NDArray rmodi(Number var1);

    public NDArray rmodi(NDArray var1);

    public NDArray rpow(Number var1);

    public NDArray rpowi(Number var1);

    public NDArray relu();

    public NDArray sigmoid();

    public NDArray tanh();

    public NDArray softrelu();

    public NDArray softsign();

    public NDArray leakyRelu(float var1);

    public NDArray elu(float var1);

    public NDArray selu();

    public NDArray gelu();

    default public NDArray swish(float beta) {
        return Activation.sigmoid(this.getArray().mul(Float.valueOf(beta))).mul(this.getArray());
    }

    default public NDArray mish() {
        return this.getArray().exp().add(1).log2().tanh().mul(this.getArray());
    }

    public NDArray maxPool(Shape var1, Shape var2, Shape var3, PoolingConvention var4);

    public NDArray globalMaxPool();

    public NDArray sumPool(Shape var1, Shape var2, Shape var3, PoolingConvention var4);

    public NDArray globalSumPool();

    public NDArray avgPool(Shape var1, Shape var2, Shape var3, PoolingConvention var4, boolean var5);

    public NDArray globalAvgPool();

    public NDArray lpPool(Shape var1, Shape var2, Shape var3, PoolingConvention var4, int var5);

    public NDArray globalLpPool(int var1);

    public void adamUpdate(NDList var1, NDList var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, boolean var10);

    public void nagUpdate(NDList var1, NDList var2, float var3, float var4, float var5, float var6, float var7);

    public void sgdUpdate(NDList var1, NDList var2, float var3, float var4, float var5, float var6, float var7, boolean var8);

    public NDList convolution(NDList var1, Shape var2, Shape var3, Shape var4, Shape var5, int var6, int var7, String var8, boolean var9, PairList<String, Object> var10);

    public NDList fullyConnected(NDList var1, long var2, boolean var4, boolean var5, PairList<String, Object> var6);

    public NDList embedding(NDList var1, int var2, int var3, DataType var4, PairList<String, Object> var5);

    public NDList prelu(NDList var1, PairList<String, Object> var2);

    public NDList dropout(NDList var1, float var2, int[] var3, PairList<String, Object> var4);

    public NDList batchNorm(NDList var1, float var2, float var3, int var4, boolean var5, boolean var6, PairList<String, Object> var7);

    public NDList rnn(NDList var1, String var2, long var3, float var5, int var6, boolean var7, boolean var8, boolean var9, PairList<String, Object> var10);

    public NDList lstm(NDList var1, long var2, float var4, int var5, boolean var6, boolean var7, boolean var8, double var9, double var11, PairList<String, Object> var13);

    /*
     * Exception decompiling
     */
    default public NDArray normalize(float[] mean, float[] std) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    default public NDArray toTensor() {
        NDArray array = this.getArray();
        int dim = array.getShape().dimension();
        if (dim == 3) {
            array = array.expandDims(0);
        }
        array = array.div(255.0).transpose(0, 3, 1, 2);
        if (dim == 3) {
            array = array.squeeze(0);
        }
        return !array.getDataType().equals((Object)DataType.FLOAT32) ? array.toType(DataType.FLOAT32, false) : array;
    }

    public NDArray resize(int var1, int var2);

    default public NDArray crop(int x, int y, int width, int height) {
        NDArray array = this.getArray();
        StringBuilder sb = new StringBuilder(30);
        if (array.getShape().dimension() == 4) {
            sb.append(":,");
        }
        sb.append(y).append(':').append(y + height).append(',').append(x).append(':').append(x + width).append(",:");
        return array.get(sb.toString());
    }

    public NDArray pick(NDArray var1, int var2, boolean var3, String var4);

    default public NDArray pick(NDArray index, int axis, boolean keepDims) {
        return this.pick(index, axis, keepDims, "clip");
    }

    public NDArray where(NDArray var1, NDArray var2);

    public NDArray stack(NDList var1, int var2);

    default public NDArray stack(NDList arrays) {
        return this.stack(arrays, 0);
    }

    public NDArray concat(NDList var1, int var2);

    default public NDArray concat(NDList arrays) {
        return this.concat(arrays, 0);
    }

    public NDList multiBoxTarget(NDList var1, float var2, float var3, float var4, float var5, int var6);

    public NDList multiBoxPrior(List<Float> var1, List<Float> var2, List<Float> var3, List<Float> var4, boolean var5);

    public NDList multiBoxDetection(NDList var1, boolean var2, float var3, int var4, float var5, boolean var6, int var7);

    public NDArray getArray();
}

