/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.repository.RepositoryFactory;
import ai.djl.repository.RepositoryFactoryImpl;
import ai.djl.util.Progress;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public interface Repository {
    public static final Gson GSON = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").setPrettyPrinting().create();

    public static Repository newInstance(String name, Path path) {
        return RepositoryFactoryImpl.getFactory().newInstance(name, path.toUri().toString());
    }

    public static Repository newInstance(String name, String url) {
        return RepositoryFactoryImpl.getFactory().newInstance(name, url);
    }

    public static void registerRepositoryFactory(RepositoryFactory factory) {
        RepositoryFactoryImpl.registerRepositoryFactory(factory);
    }

    public boolean isRemote();

    public String getName();

    public URI getBaseUri();

    public Metadata locate(MRL var1) throws IOException;

    public Artifact resolve(MRL var1, String var2, Map<String, String> var3) throws IOException;

    public InputStream openStream(Artifact.Item var1, String var2) throws IOException;

    public Path getFile(Artifact.Item var1, String var2) throws IOException;

    public String[] listDirectory(Artifact.Item var1, String var2) throws IOException;

    default public void prepare(Artifact artifact) throws IOException {
        this.prepare(artifact, null);
    }

    public void prepare(Artifact var1, Progress var2) throws IOException;

    public Path getCacheDirectory() throws IOException;

    default public Path getResourceDirectory(Artifact artifact) throws IOException {
        return this.getCacheDirectory().resolve(artifact.getResourceUri().getPath());
    }

    public List<MRL> getResources();
}

