/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.Model;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.translator.BaseImageTranslator;
import ai.djl.ndarray.NDManager;
import java.io.IOException;
import java.util.List;

public abstract class ObjectDetectionTranslator
extends BaseImageTranslator<DetectedObjects> {
    protected float threshold;
    private BaseImageTranslator.SynsetLoader synsetLoader;
    protected List<String> classes;
    protected double imageWidth;
    protected double imageHeight;

    protected ObjectDetectionTranslator(BaseBuilder<?> builder) {
        super(builder);
        this.threshold = builder.threshold;
        this.synsetLoader = builder.synsetLoader;
        this.imageWidth = builder.imageWidth;
        this.imageHeight = builder.imageHeight;
    }

    @Override
    public void prepare(NDManager manager, Model model) throws IOException {
        if (this.classes == null) {
            this.classes = this.synsetLoader.load(model);
        }
    }

    public static abstract class BaseBuilder<T extends BaseBuilder>
    extends BaseImageTranslator.ClassificationBuilder<T> {
        protected float threshold = 0.2f;
        protected double imageWidth;
        protected double imageHeight;

        @Override
        protected abstract T self();

        public T optThreshold(float threshold) {
            this.threshold = threshold;
            return (T)this.self();
        }

        public T optRescaleSize(double imageWidth, double imageHeight) {
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            return (T)this.self();
        }

        public float getThreshold() {
            return this.threshold;
        }

        public double getImageWidth() {
            return this.imageWidth;
        }

        public double getImageHeight() {
            return this.imageHeight;
        }
    }
}

