/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.util;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.types.Shape;

public final class NDImageUtils {
    private NDImageUtils() {
    }

    public static NDArray resize(NDArray image, int size) {
        return image.getNDArrayInternal().resize(size, size);
    }

    public static NDArray resize(NDArray image, int width, int height) {
        return image.getNDArrayInternal().resize(width, height);
    }

    public static NDArray normalize(NDArray input, float mean, float std) {
        return NDImageUtils.normalize(input, new float[]{mean, mean, mean}, new float[]{std, std, std});
    }

    public static NDArray normalize(NDArray input, float[] mean, float[] std) {
        return input.getNDArrayInternal().normalize(mean, std);
    }

    public static NDArray toTensor(NDArray image) {
        return image.getNDArrayInternal().toTensor();
    }

    public static NDArray centerCrop(NDArray image) {
        int h;
        Shape shape = image.getShape();
        int w = (int)shape.get(1);
        if (w == (h = (int)shape.get(0))) {
            return image;
        }
        if (w > h) {
            return NDImageUtils.centerCrop(image, h, h);
        }
        return NDImageUtils.centerCrop(image, w, w);
    }

    public static NDArray centerCrop(NDArray image, int width, int height) {
        int y;
        int x;
        Shape shape = image.getShape();
        int w = (int)shape.get(1);
        int h = (int)shape.get(0);
        int dw = (w - width) / 2;
        int dh = (h - height) / 2;
        if (dw > 0) {
            x = dw;
            w = width;
        } else {
            x = 0;
        }
        if (dh > 0) {
            y = dh;
            h = height;
        } else {
            y = 0;
        }
        return NDImageUtils.crop(image, x, y, w, h);
    }

    public static NDArray crop(NDArray image, int x, int y, int width, int height) {
        return image.getNDArrayInternal().crop(x, y, width, height);
    }
}

