/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.nn.core;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.AbstractBlock;
import ai.djl.nn.core.AbstractIndexedEmbedding;
import ai.djl.training.ParameterStore;
import ai.djl.util.PairList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Optional;

public class ConstantEmbedding
extends AbstractBlock
implements AbstractIndexedEmbedding {
    private static final byte VERSION = 1;
    protected NDArray embedding;

    public ConstantEmbedding(NDArray embedding) {
        super((byte)1);
        this.embedding = embedding;
    }

    @Override
    public NDList forward(ParameterStore parameterStore, NDList inputs, boolean training, PairList<String, Object> params) {
        NDManager manager = ((NDArray)inputs.get(0)).getManager();
        NDArray base = manager.create(this.embedding.getShape());
        this.embedding.copyTo(base);
        Shape shape = ((NDArray)inputs.get(0)).getShape().addAll(this.embedding.getShape());
        return new NDList(base.repeat(shape));
    }

    @Override
    public Shape[] getOutputShapes(NDManager manager, Shape[] inputShapes) {
        return new Shape[]{inputShapes[0].addAll(this.embedding.getShape())};
    }

    @Override
    public void saveParameters(DataOutputStream os) {
    }

    @Override
    public void loadParameters(NDManager manager, DataInputStream is) {
    }

    public Optional<?> unembed(int index) {
        return Optional.empty();
    }

    public byte[] encode(Object input) {
        return new byte[0];
    }

    public Object decode(byte[] byteArray) {
        return null;
    }

    public int embed(Object item) {
        return 0;
    }

    @Override
    public NDArray embed(NDManager manager, Object[] items) {
        NDArray base = manager.create(this.embedding.getShape());
        this.embedding.copyTo(base);
        Shape shape = new Shape(items.length).addAll(this.embedding.getShape());
        return base.repeat(shape);
    }

    @Override
    public boolean hasItem(Object item) {
        return true;
    }
}

