/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.zoo;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.translator.InstanceSegmentationTranslator;
import ai.djl.modality.cv.translator.wrapper.FileTranslatorFactory;
import ai.djl.modality.cv.translator.wrapper.InputStreamTranslatorFactory;
import ai.djl.modality.cv.translator.wrapper.UrlTranslatorFactory;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import ai.djl.util.Progress;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;

public class InstanceSegmentationModelLoader
extends BaseModelLoader {
    private static final Application APPLICATION = Application.CV.INSTANCE_SEGMENTATION;

    public InstanceSegmentationModelLoader(Repository repository, String groupId, String artifactId, String version, ModelZoo modelZoo) {
        super(repository, MRL.model(APPLICATION, groupId, artifactId), version, modelZoo);
        FactoryImpl factory = new FactoryImpl();
        this.factories.put(new Pair<Class<Image>, Class<DetectedObjects>>(Image.class, DetectedObjects.class), factory);
        this.factories.put(new Pair<Class<Path>, Class<DetectedObjects>>(Path.class, DetectedObjects.class), new FileTranslatorFactory<DetectedObjects>(factory));
        this.factories.put(new Pair<Class<URL>, Class<DetectedObjects>>(URL.class, DetectedObjects.class), new UrlTranslatorFactory<DetectedObjects>(factory));
        this.factories.put(new Pair<Class<InputStream>, Class<DetectedObjects>>(InputStream.class, DetectedObjects.class), new InputStreamTranslatorFactory<DetectedObjects>(factory));
    }

    public ZooModel<Image, DetectedObjects> loadModel() throws MalformedModelException, ModelNotFoundException, IOException {
        return this.loadModel(null, null, null);
    }

    public ZooModel<Image, DetectedObjects> loadModel(Progress progress) throws MalformedModelException, ModelNotFoundException, IOException {
        return this.loadModel(null, null, progress);
    }

    public ZooModel<Image, DetectedObjects> loadModel(Map<String, String> filters, Device device, Progress progress) throws IOException, ModelNotFoundException, MalformedModelException {
        Criteria<Image, DetectedObjects> criteria = Criteria.builder().setTypes(Image.class, DetectedObjects.class).optModelZoo(this.modelZoo).optGroupId(this.resource.getMrl().getGroupId()).optArtifactId(this.resource.getMrl().getArtifactId()).optFilters(filters).optDevice(device).optProgress(progress).build();
        return this.loadModel(criteria);
    }

    private static final class FactoryImpl
    implements TranslatorFactory<Image, DetectedObjects> {
        private FactoryImpl() {
        }

        @Override
        public Translator<Image, DetectedObjects> newInstance(Model model, Map<String, Object> arguments) {
            return InstanceSegmentationTranslator.builder(arguments).build();
        }
    }
}

