/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.optimizer;

import ai.djl.Device;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.training.optimizer.Optimizer;
import ai.djl.training.tracker.Tracker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RmsProp
extends Optimizer {
    private Tracker learningRateTracker;
    private float rho;
    private float momentum;
    private float epsilon;
    private boolean centered;
    private Map<String, Map<Device, NDArray>> means;
    private Map<String, Map<Device, NDArray>> variances;
    private Map<String, Map<Device, NDArray>> momentums;

    protected RmsProp(Builder builder) {
        super(builder);
        this.learningRateTracker = builder.learningRateTracker;
        this.rho = builder.rho;
        this.momentum = builder.momentum;
        this.epsilon = builder.epsilon;
        this.centered = builder.centered;
        this.means = new ConcurrentHashMap<String, Map<Device, NDArray>>();
        this.variances = new ConcurrentHashMap<String, Map<Device, NDArray>>();
        this.momentums = new ConcurrentHashMap<String, Map<Device, NDArray>>();
    }

    @Override
    public void update(String parameterId, NDArray weight, NDArray grad) {
        float newLearningRate = this.learningRateTracker.getNewValue(this.updateCount(parameterId));
        float weightDecay = this.getWeightDecay();
        if (Float.isNaN(newLearningRate) || Float.isNaN(weightDecay) || Float.isInfinite(newLearningRate) || Float.isInfinite(weightDecay)) {
            throw new IllegalStateException("learning rate or weight decay is nan or infinite");
        }
        NDList inputs = !this.centered ? new NDList(weight, grad, this.withDefaultState(this.means, parameterId, weight.getDevice(), k -> weight.zerosLike())) : new NDList(weight, grad, this.withDefaultState(this.means, parameterId, weight.getDevice(), k -> weight.zerosLike()), this.withDefaultState(this.variances, parameterId, weight.getDevice(), k -> weight.zerosLike()), this.withDefaultState(this.momentums, parameterId, weight.getDevice(), k -> weight.zerosLike()));
        NDList weights = new NDList(weight);
        float gamma1 = this.rho;
        float gamma2 = this.momentum;
        NDArrayEx ex = weight.getNDArrayInternal();
        ex.rmspropUpdate(inputs, weights, newLearningRate, weightDecay, this.rescaleGrad, this.clipGrad, gamma1, gamma2, this.epsilon, this.centered);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Optimizer.OptimizerBuilder<Builder> {
        private Tracker learningRateTracker = Tracker.fixed(0.001f);
        private float rho = 0.9f;
        private float momentum = 0.9f;
        private float epsilon = 1.0E-8f;
        private boolean centered;

        Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder optLearningRateTracker(Tracker learningRateTracker) {
            this.learningRateTracker = learningRateTracker;
            return this;
        }

        public Builder optRho(float rho) {
            this.rho = rho;
            return this;
        }

        public Builder optMomentum(float momentum) {
            this.momentum = momentum;
            return this;
        }

        public Builder optEpsilon(float epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Builder optCentered(boolean centered) {
            this.centered = centered;
            return this;
        }

        public RmsProp build() {
            return new RmsProp(this);
        }
    }
}

