/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.tracker;

import ai.djl.training.tracker.Tracker;
import ai.djl.util.Preconditions;

public class LinearTracker
implements Tracker {
    private float baseValue;
    private float slope;
    private int maxUpdates;

    public LinearTracker(Builder builder) {
        this.baseValue = builder.baseValue;
        this.slope = builder.slope;
        this.maxUpdates = builder.maxUpdates;
    }

    @Override
    public float getNewValue(int numUpdate) {
        if (numUpdate > this.maxUpdates) {
            numUpdate = this.maxUpdates;
        }
        return this.baseValue + (float)numUpdate * this.slope;
    }

    public static final class Builder {
        float baseValue;
        float slope;
        Float min;
        Float max;
        Integer maxUpdates;

        public Builder setBaseValue(float baseValue) {
            this.baseValue = baseValue;
            return this;
        }

        public Builder optSlope(float slope) {
            this.slope = slope;
            return this;
        }

        public Builder optMaxValue(float max) {
            this.max = Float.valueOf(max);
            return this;
        }

        public Builder optMinValue(float min) {
            this.min = Float.valueOf(min);
            return this;
        }

        public Builder optMaxUpdates(int maxUpdates) {
            this.maxUpdates = maxUpdates;
            return this;
        }

        public LinearTracker build() {
            Preconditions.checkArgument(this.slope != 0.0f, "You must set a slope");
            Preconditions.checkArgument(this.min == null || this.max == null, "You can not set both a max value and a min value");
            if (this.max != null) {
                Preconditions.checkArgument(this.maxUpdates == null, "You can not set both maxUpdates and a max value");
                Preconditions.checkArgument(this.slope > 0.0f, "The slope must be positive for a max value");
                Preconditions.checkArgument(this.max.floatValue() > this.baseValue, "The max must be greater than the base value");
                this.maxUpdates = Math.round((this.max.floatValue() - this.baseValue) / this.slope);
            } else if (this.min != null) {
                Preconditions.checkArgument(this.maxUpdates == null, "You can not set both maxUpdates and a min value");
                Preconditions.checkArgument(this.slope < 0.0f, "The slope must be negative for a min value");
                Preconditions.checkArgument(this.min.floatValue() < this.baseValue, "The min must be smaller than the base value");
                this.maxUpdates = Math.round((this.baseValue - this.min.floatValue()) / this.slope);
            } else if (this.maxUpdates == null) {
                this.maxUpdates = Integer.MAX_VALUE;
            }
            return new LinearTracker(this);
        }
    }
}

