/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.tracker;

import ai.djl.training.tracker.Tracker;
import ai.djl.util.Preconditions;

public class CosineTracker
implements Tracker {
    private float baseValue;
    private float finalValue;
    private int maxUpdates;

    public CosineTracker(Builder builder) {
        this.baseValue = builder.baseValue;
        this.finalValue = builder.finalValue;
        this.maxUpdates = builder.maxUpdates;
    }

    @Override
    public float getNewValue(int numUpdate) {
        if (numUpdate > this.maxUpdates) {
            return this.finalValue;
        }
        float step = (this.baseValue - this.finalValue) / 2.0f * (1.0f + (float)Math.cos(Math.PI * (double)numUpdate / (double)this.maxUpdates));
        return this.finalValue + step;
    }

    public static final class Builder {
        private float baseValue;
        private float finalValue = 0.01f;
        int maxUpdates;

        public Builder setBaseValue(float baseValue) {
            this.baseValue = baseValue;
            return this;
        }

        public Builder optFinalValue(float finalValue) {
            this.finalValue = finalValue;
            return this;
        }

        public Builder setMaxUpdates(int maxUpdates) {
            this.maxUpdates = maxUpdates;
            return this;
        }

        public CosineTracker build() {
            Preconditions.checkArgument(this.baseValue > 0.0f, "You must set a starting learning rate!");
            Preconditions.checkArgument(this.maxUpdates > 0, "You must set a maximum number of updates!");
            Preconditions.checkArgument(this.baseValue > this.finalValue, "Starting learning rate must be greater than final learning rate!");
            return new CosineTracker(this);
        }
    }
}

