/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class OPTRecord
extends Record {
    private List<EDNSOption> options;

    OPTRecord() {
    }

    public OPTRecord(int payloadSize, int xrcode, int version, int flags, List<EDNSOption> options) {
        super(Name.root, 41, payloadSize, 0L);
        OPTRecord.checkU16("payloadSize", payloadSize);
        OPTRecord.checkU8("xrcode", xrcode);
        OPTRecord.checkU8("version", version);
        OPTRecord.checkU16("flags", flags);
        this.ttl = ((long)xrcode << 24) + ((long)version << 16) + (long)flags;
        if (options != null) {
            this.options = new ArrayList<EDNSOption>(options);
        }
    }

    public OPTRecord(int payloadSize, int xrcode, int version, int flags) {
        this(payloadSize, xrcode, version, flags, null);
    }

    public OPTRecord(int payloadSize, int xrcode, int version) {
        this(payloadSize, xrcode, version, 0, null);
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        if (in.remaining() > 0) {
            this.options = new ArrayList<EDNSOption>();
        }
        while (in.remaining() > 0) {
            EDNSOption option = EDNSOption.fromWire(in);
            this.options.add(option);
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        throw st.exception("no text format defined for OPT");
    }

    @Override
    String rrToString() {
        StringBuilder sb = new StringBuilder();
        if (this.options != null) {
            sb.append(this.options);
            sb.append(" ");
        }
        sb.append(" ; payload ");
        sb.append(this.getPayloadSize());
        sb.append(", xrcode ");
        sb.append(this.getExtendedRcode());
        sb.append(", version ");
        sb.append(this.getVersion());
        sb.append(", flags ");
        sb.append(this.getFlags());
        return sb.toString();
    }

    public int getPayloadSize() {
        return this.dclass;
    }

    public int getExtendedRcode() {
        return (int)(this.ttl >>> 24);
    }

    public int getVersion() {
        return (int)(this.ttl >>> 16 & 0xFFL);
    }

    public int getFlags() {
        return (int)(this.ttl & 0xFFFFL);
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        if (this.options == null) {
            return;
        }
        for (EDNSOption option : this.options) {
            option.toWire(out);
        }
    }

    public List<EDNSOption> getOptions() {
        if (this.options == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.options);
    }

    public List<EDNSOption> getOptions(int code) {
        if (this.options == null) {
            return Collections.emptyList();
        }
        ArrayList<EDNSOption> list = new ArrayList<EDNSOption>();
        for (EDNSOption opt : this.options) {
            if (opt.getCode() != code) continue;
            list.add(opt);
        }
        return list;
    }

    @Override
    public boolean equals(Object arg) {
        return super.equals(arg) && this.ttl == ((OPTRecord)arg).ttl;
    }

    @Override
    public int hashCode() {
        byte[] array = this.toWireCanonical();
        int code = 0;
        for (byte b : array) {
            code += (code << 3) + (b & 0xFF);
        }
        return code;
    }
}

