/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.Address;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class AAAARecord
extends Record {
    private byte[] address;

    AAAARecord() {
    }

    public AAAARecord(Name name, int dclass, long ttl, InetAddress address) {
        super(name, 28, dclass, ttl);
        if (Address.familyOf(address) != 2) {
            throw new IllegalArgumentException("invalid IPv6 address");
        }
        this.address = address.getAddress();
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        this.address = in.readByteArray(16);
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.address = st.getAddressBytes(2);
    }

    @Override
    protected String rrToString() {
        InetAddress addr;
        try {
            addr = InetAddress.getByAddress(null, this.address);
        }
        catch (UnknownHostException e) {
            return null;
        }
        if (addr.getAddress().length == 4) {
            StringBuilder sb = new StringBuilder("0:0:0:0:0:ffff:");
            int high = ((this.address[12] & 0xFF) << 8) + (this.address[13] & 0xFF);
            int low = ((this.address[14] & 0xFF) << 8) + (this.address[15] & 0xFF);
            sb.append(Integer.toHexString(high));
            sb.append(':');
            sb.append(Integer.toHexString(low));
            return sb.toString();
        }
        return addr.getHostAddress();
    }

    public InetAddress getAddress() {
        try {
            if (this.name == null) {
                return InetAddress.getByAddress(this.address);
            }
            return InetAddress.getByAddress(this.name.toString(), this.address);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.address);
    }
}

