/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.config;

import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.config.InitializationException;
import org.xbill.DNS.config.ResolverConfigProvider;

public class SunJvmResolverConfigProvider
implements ResolverConfigProvider {
    private List<InetSocketAddress> nameservers = null;
    private List<Name> searchlist = null;

    @Override
    public void initialize() throws InitializationException {
        try {
            Class<?> resConfClass = Class.forName("sun.net.dns.ResolverConfiguration");
            Method open = resConfClass.getDeclaredMethod("open", new Class[0]);
            Object resConf = open.invoke(null, new Object[0]);
            Method nameserversMethod = resConfClass.getMethod("nameservers", new Class[0]);
            List jvmNameservers = (List)nameserversMethod.invoke(resConf, new Object[0]);
            this.nameservers = jvmNameservers.stream().map(ns -> new InetSocketAddress((String)ns, 53)).collect(Collectors.toList());
            Method searchlistMethod = resConfClass.getMethod("searchlist", new Class[0]);
            List jvmSearchlist = (List)searchlistMethod.invoke(resConf, new Object[0]);
            this.searchlist = jvmSearchlist.stream().map(n -> {
                try {
                    return Name.fromString(n, Name.root);
                }
                catch (TextParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new InitializationException(e);
        }
    }

    @Override
    public List<InetSocketAddress> servers() {
        if (this.nameservers == null) {
            throw new IllegalStateException("not initialized");
        }
        return Collections.unmodifiableList(this.nameservers);
    }

    @Override
    public List<Name> searchPaths() {
        if (this.searchlist == null) {
            throw new IllegalStateException("not initialized");
        }
        return Collections.unmodifiableList(this.searchlist);
    }

    @Override
    public boolean isEnabled() {
        return Boolean.getBoolean("dnsjava.configprovider.sunjvm.enabled");
    }
}

