/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import org.apache.camel.Exchange;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.StringHelper;

public class EnumTypeConverter
extends TypeConverterSupport {
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return EnumTypeConverter.doConvertTo(type, exchange, value);
    }

    public static <T> T doConvertTo(Class<T> type, Exchange exchange, Object value) {
        if (type.isEnum()) {
            String text = value.toString();
            Class<T> enumClass = type;
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                if (!enumValue.name().equalsIgnoreCase(text)) continue;
                return type.cast(enumValue);
            }
            text = StringHelper.asEnumConstantValue((String)text);
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                if (!enumValue.name().equalsIgnoreCase(text)) continue;
                return type.cast(enumValue);
            }
            throw new IllegalArgumentException("Enum class " + type + " does not have any constant with value: " + text);
        }
        return null;
    }
}

