/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.config.resolvers;

import com.github.dozermapper.core.config.resolvers.SettingsResolver;
import com.github.dozermapper.core.util.DozerClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyPropertiesSettingsResolver
implements SettingsResolver {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyPropertiesSettingsResolver.class);
    private final DozerClassLoader classLoader;
    private final String configFile;
    private Properties properties;

    public LegacyPropertiesSettingsResolver(DozerClassLoader classLoader, String configFile) {
        this.classLoader = classLoader;
        this.configFile = configFile;
    }

    @Override
    public void init() {
        this.properties = this.processFile();
    }

    private Properties processFile() {
        Properties properties = new Properties();
        String extension = FilenameUtils.getExtension((String)this.configFile);
        if (!extension.equalsIgnoreCase("properties")) {
            LOG.info("Ignoring, as file extension is not correct for: {}", (Object)this.configFile);
        } else {
            LOG.info("Trying to find Dozer configuration file: {}", (Object)this.configFile);
            URL url = this.classLoader.loadResource(this.configFile);
            if (url == null) {
                LOG.info("Failed to find {} via {}.", (Object)this.configFile, (Object)this.getClass().getName());
            } else {
                LOG.info("Using URL [{}] for Dozer settings", (Object)url);
                try (InputStream inputStream = url.openStream();){
                    properties.load(inputStream);
                }
                catch (IOException ex) {
                    LOG.error("Failed to load: {} because: {}", (Object)this.configFile, (Object)ex.getMessage());
                    LOG.debug("Exception: ", (Throwable)ex);
                }
            }
        }
        return properties;
    }

    @Override
    public Object get(String key, Object defaultValue) {
        return this.properties.getOrDefault((Object)key, defaultValue);
    }
}

