/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.fieldmap;

import com.github.dozermapper.core.classmap.ClassMap;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.fieldmap.FieldMap;
import com.github.dozermapper.core.propertydescriptor.AbstractPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.DozerPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.FieldPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.JavaBeanPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.MapPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.PropertyDescriptorFactory;
import com.github.dozermapper.core.util.MappingUtils;

public class MapFieldMap
extends FieldMap {
    public MapFieldMap(ClassMap classMap, BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        super(classMap, beanContainer, destBeanCreator, propertyDescriptorFactory);
    }

    public MapFieldMap(FieldMap fieldMap, BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        super(fieldMap.getClassMap(), beanContainer, destBeanCreator, propertyDescriptorFactory);
        this.setCopyByReference(fieldMap.isCopyByReference());
        this.setCustomConverter(fieldMap.getCustomConverter());
        this.setCustomConverterId(fieldMap.getCustomConverterId());
        this.setCustomConverterParam(fieldMap.getCustomConverterParam());
        this.setDestField(fieldMap.getDestField());
        this.setDestHintContainer(fieldMap.getDestHintContainer());
        this.setDestDeepIndexHintContainer(fieldMap.getDestDeepIndexHintContainer());
        this.setMapId(fieldMap.getMapId());
        this.setRelationshipType(fieldMap.getRelationshipType());
        this.setRemoveOrphans(fieldMap.isRemoveOrphans());
        this.setSrcField(fieldMap.getSrcField());
        this.setSrcHintContainer(fieldMap.getSrcHintContainer());
        this.setSrcDeepIndexHintContainer(fieldMap.getSrcDeepIndexHintContainer());
        this.setType(fieldMap.getType());
    }

    @Override
    public void writeDestValue(Object destObj, Object destFieldValue) {
        DozerPropertyDescriptor propDescriptor;
        Object targetObject = destObj;
        if (this.getDestFieldName().equals("this") || destFieldValue != null && MappingUtils.isSupportedMap(destFieldValue.getClass())) {
            propDescriptor = super.getDestPropertyDescriptor(destObj.getClass());
        } else if (this.getDestFieldMapGetMethod() != null || MappingUtils.isSupportedMap(this.determineActualPropertyType(this.getDestFieldName(), this.isDestFieldIndexed(), this.getDestFieldIndex(), destObj, true))) {
            PrepareTargetObjectResult result = this.prepareTargetObject(destObj);
            targetObject = result.targetObject;
            propDescriptor = result.propDescriptor;
        } else {
            propDescriptor = super.getDestPropertyDescriptor(destObj.getClass());
        }
        propDescriptor.setPropertyValue(targetObject, destFieldValue, this);
    }

    @Override
    public Object getSrcFieldValue(Object srcObj) {
        DozerPropertyDescriptor propDescriptor;
        Object targetObject = srcObj;
        if (this.getSrcFieldName().equals("this")) {
            propDescriptor = super.getSrcPropertyDescriptor(srcObj.getClass());
        } else {
            Class<?> actualType = this.determineActualPropertyType(this.getSrcFieldName(), this.isSrcFieldIndexed(), this.getSrcFieldIndex(), srcObj, false);
            if (this.getSrcFieldMapGetMethod() != null || this.getMapId() == null && MappingUtils.isSupportedMap(actualType) && this.getSrcHintContainer() == null) {
                targetObject = super.getSrcFieldValue(srcObj);
                String setMethod = MappingUtils.isSupportedMap(actualType) ? "put" : this.getSrcFieldMapSetMethod();
                String getMethod = MappingUtils.isSupportedMap(actualType) ? "get" : this.getSrcFieldMapGetMethod();
                String key = this.getSrcFieldKey() != null ? this.getSrcFieldKey() : this.getDestFieldName();
                propDescriptor = new MapPropertyDescriptor(actualType, this.getSrcFieldName(), this.isSrcFieldIndexed(), this.getDestFieldIndex(), setMethod, getMethod, key, this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer(), this.beanContainer, this.destBeanCreator);
            } else {
                propDescriptor = super.getSrcPropertyDescriptor(srcObj.getClass());
            }
        }
        Object result = null;
        if (targetObject != null) {
            result = propDescriptor.getPropertyValue(targetObject);
        }
        return result;
    }

    private PrepareTargetObjectResult prepareTargetObject(Object destObj) {
        AbstractPropertyDescriptor pd = this.isDestFieldAccessible() ? new FieldPropertyDescriptor(destObj.getClass(), this.getDestFieldName(), this.isDestFieldIndexed(), this.getDestFieldIndex(), this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer(), this.destBeanCreator) : new JavaBeanPropertyDescriptor(destObj.getClass(), this.getDestFieldName(), this.isDestFieldIndexed(), this.getDestFieldIndex(), this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer(), this.beanContainer, this.destBeanCreator);
        Class<?> c = pd.getPropertyType();
        Object targetObject = pd.getPropertyValue(destObj);
        if (targetObject == null) {
            if (this.getDestHintContainer() != null) {
                if (MappingUtils.isSupportedMap(c)) {
                    if (MappingUtils.isSupportedMap(this.getDestHintContainer().getHint())) {
                        c = this.getDestHintContainer().getHint();
                    }
                } else {
                    c = this.getDestHintContainer().getHint();
                }
            }
            targetObject = this.destBeanCreator.create(c, destObj.getClass());
            pd.setPropertyValue(destObj, targetObject, this);
        }
        return new PrepareTargetObjectResult(targetObject, new MapPropertyDescriptor(c, this.getDestFieldName(), this.isDestFieldIndexed(), this.getDestFieldIndex(), MappingUtils.isSupportedMap(c) ? "put" : this.getDestFieldMapSetMethod(), MappingUtils.isSupportedMap(c) ? "get" : this.getDestFieldMapGetMethod(), this.getDestFieldKey() != null ? this.getDestFieldKey() : this.getSrcFieldName(), this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer(), this.beanContainer, this.destBeanCreator));
    }

    private Class<?> determineActualPropertyType(String fieldName, boolean isIndexed, int index, Object targetObj, boolean isDestObj) {
        AbstractPropertyDescriptor pd = isDestObj && this.isDestFieldAccessible() || !isDestObj && this.isSrcFieldAccessible() ? new FieldPropertyDescriptor(targetObj.getClass(), fieldName, isIndexed, index, this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer(), this.destBeanCreator) : new JavaBeanPropertyDescriptor(targetObj.getClass(), fieldName, isIndexed, index, this.getSrcDeepIndexHintContainer(), this.getDestDeepIndexHintContainer(), this.beanContainer, this.destBeanCreator);
        return pd.getPropertyType();
    }

    private static class PrepareTargetObjectResult {
        private Object targetObject;
        private MapPropertyDescriptor propDescriptor;

        PrepareTargetObjectResult(Object targetObject, MapPropertyDescriptor propDescriptor) {
            this.targetObject = targetObject;
            this.propDescriptor = propDescriptor;
        }
    }
}

