/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.converters;

import com.github.dozermapper.core.converters.ConversionException;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.apache.commons.beanutils.Converter;

public final class InstantConverter
implements Converter {
    public Object convert(Class destClass, Object srcObject) {
        Class<?> srcObjectClass = srcObject.getClass();
        if (Date.class.isAssignableFrom(srcObjectClass)) {
            Instant instant = ((Date)srcObject).toInstant();
            return instant;
        }
        if (Instant.class.isAssignableFrom(srcObjectClass)) {
            return Instant.from((Instant)srcObject);
        }
        if (TemporalAccessor.class.isAssignableFrom(srcObjectClass)) {
            return Instant.from((TemporalAccessor)srcObject);
        }
        if (String.class.isAssignableFrom(srcObjectClass)) {
            return Instant.parse((String)srcObject);
        }
        throw new ConversionException(String.format("Unsupported source object type: %s", srcObjectClass), null);
    }
}

