/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.converters;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class DateFormatContainer {
    private String dfStr;
    private DateFormat dateFormat;
    private DateTimeFormatter dateTimeFormatter;

    public DateFormatContainer(String dfStr) {
        this.dfStr = dfStr;
    }

    public boolean isPresent() {
        return this.dfStr != null || this.dateFormat != null;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = this.determineDateFormat();
        }
        return this.dateFormat;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        if (this.dateTimeFormatter == null && this.dfStr != null) {
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.dfStr);
        }
        return this.dateTimeFormatter;
    }

    @Deprecated
    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    private DateFormat determineDateFormat() {
        return this.dfStr == null ? null : new SimpleDateFormat(this.dfStr, Locale.getDefault());
    }
}

